/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-imobiliario"})
public class CadastroImobiliarioResource
extends CrudResource<CadastroImobiliario, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final RelatorioResource relatorioResource;

    public CadastroImobiliarioResource(CadastroImobiliarioService cadastroImobiliarioService, RelatorioResource relatorioResource) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.relatorioResource = relatorioResource;
    }

    @GetMapping(path={"/imprimir-espelho"}, params={"cadastroGeral"})
    public void imprimirEspelho(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.cadastroImobiliarioService.buildImpressaoEspelhoDTO(cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }
}

