/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoHistoricoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoInformacaoDashDebitoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtendimentoService;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atendimentos"})
public class AtendimentoResource {
    private final AtendimentoService atendimentoService;

    public AtendimentoResource(AtendimentoService atendimentoService) {
        this.atendimentoService = atendimentoService;
    }

    @GetMapping(value={"/debitos-aberto"})
    public ResponseEntity<List<DebitoEmAbertoDTO>> getDebitosEmAberto() {
        return this.atendimentoService.loadAtendimentoUser(SecurityUtils.getUserId()).map(atendimento -> this.atendimentoService.findDebitosEmAberto(atendimento.getCadastroGeral().getIdCadastro())).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi encontrado atendimento em aberto para o usu\u00e1rio logado."));
    }

    @GetMapping(value={"/{id}/debitos/info"})
    public ResponseEntity<AtendimentoInformacaoDashDebitoDTO> getValorTotalDebito(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.atendimentoService.getValorTotalDebito(id));
    }

    @GetMapping(value={"/{id}/parcelamentos/info"})
    public ResponseEntity<AtendimentoInformacaoDashDebitoDTO> getValorTotalParcelamentos(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.atendimentoService.getValorTotalParcelamentos(id));
    }

    @GetMapping(value={"/search-contribuinte"})
    public ResponseEntity<Page<AtendimentoPessoaDTO>> searchPessoa(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchPessoa(search, pageable));
    }

    @GetMapping(value={"/search-cadastros/by-cadastro-geral/{cadastroGeral}"})
    public ResponseEntity<List<EnderecoCadastroGeralDTO>> searchCadastrosByCadastroGeral(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchCadastrosByCadastroGeral(cadastroGeral));
    }

    @GetMapping(value={"/search-cadastros/by-pessoa/{codigoPessoa}"})
    public ResponseEntity<List<EnderecoCadastroGeralDTO>> searchCadastrosByPessoa(@PathVariable Long codigoPessoa) {
        return ResponseEntity.ok((Object)this.atendimentoService.searchCadastrosByPessoa(codigoPessoa));
    }

    @PostMapping
    public ResponseEntity<AtendimentoDTO> save(@RequestBody @Valid AtendimentoDTO atendimento) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.atendimentoService.save(atendimento));
    }

    @PutMapping(value={"/{idAtendimento}/trocar-cadastro/{idCadastro}"})
    public ResponseEntity<AtendimentoDTO> update(@PathVariable Long idAtendimento, @PathVariable Long idCadastro) {
        Atendimento atendimentoUpdated = this.atendimentoService.trocaCadastro(idAtendimento, idCadastro);
        return ResponseEntity.ok((Object)AtendimentoDTO.from((Atendimento)atendimentoUpdated));
    }

    @PutMapping(value={"/{idAtendimento}/finalizar"})
    public ResponseEntity<Void> finalizarAtendimento(@PathVariable Long idAtendimento) {
        this.atendimentoService.finalizarAtendimento(idAtendimento);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idAtendimento}"})
    public ResponseEntity<AtendimentoDTO> loadAtendimento(@PathVariable Long idAtendimento) {
        Optional found = this.atendimentoService.findOne(idAtendimento);
        if (found.isPresent()) {
            return ResponseEntity.ok((Object)AtendimentoDTO.from((Atendimento)((Atendimento)found.get())));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{cadastroGeral}/historicos"})
    public ResponseEntity<List<AtendimentoHistoricoDTO>> loadHistoricos(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.atendimentoService.loadHistoricos(cadastroGeral));
    }

    @GetMapping(value={"/current"})
    public ResponseEntity<AtendimentoDTO> loadAtendimentoCurrent() {
        Optional found = this.atendimentoService.loadAtendimentoUser(SecurityUtils.getUserId());
        if (found.isPresent()) {
            return ResponseEntity.ok(found.get());
        }
        return ResponseEntity.noContent().build();
    }
}

