/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaPagamentoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDTO;
import br.com.elotech.tributos.repository.PagamentoRepositoryCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PagamentoRepositoryImpl
implements PagamentoRepositoryCustom {
    private static final String SQL_PAGAMENTOS_PARCELA = "sql/ConsultaDebitoParcelaPagamento.sql";
    private static final String SQL_PAGAMENTOS_EXISTENTES_MESMA_PARCELA_TRIBUTO = "br/com/elotech/tributos/repository/pagamento/existePagamentoMesmaParcelaTributo.sql";
    private static final String SQL_DEBITO_QUITADO_BY_PAGAMENTO = "br/com/elotech/tributos/repository/pagamento/find-debito-quitado-by-pagamento.sql";
    private static final String ENTIDADE = "entidade";
    private final EntityManager em;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public PagamentoRepositoryImpl(EntityManager em, NamedParameterJdbcTemplate jdbcTemplate) {
        this.em = em;
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaPagamentoDTO> loadDebitoParcelaPagamento(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_PAGAMENTOS_PARCELA);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)debito.getEntidade());
        parameters.addValue("exercicio", (Object)debito.getExercicio());
        parameters.addValue("tipoCadastro", (Object)debito.getTipoCadastro());
        parameters.addValue("cadastroGeral", (Object)debito.getCadastroGeral().getCadastroGeral());
        parameters.addValue("divida", (Object)debito.getDivida().getDivida());
        parameters.addValue("subDivida", (Object)debito.getSubDivida());
        parameters.addValue("parcela", (Object)parcela);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaPagamentoDTO.class));
    }

    public Page<PagamentoDTO> findPagamentosDTO(Long entidade, FiltroPagamentoDTO filtroPagamento, Pageable pageable) {
        String sqlFrom = String.format(" from Pagamento pagamento  join pagamento.pagamentoBoleto pagamentoBoleto  join pagamentoBoleto.boleto boleto  join boleto.pessoa pessoa  join pagamento.lote lote  join pagamentoBoleto.pagamentosDebito pagamentosDebito  join pagamentosDebito.id.debitoParcelaTributo tributo  join tributo.debitoParcela debitoParcela  where pagamento.id.entidade = :entidade  %s ", filtroPagamento.buildFiltro());
        String sqlPagamentos = String.format("select distinct pagamento.id.entidade as entidade,  pagamento.id.exercicioPagamento as exercicioPagamento,  pagamento.id.pagamento as pagamento,  lote.id.exercicio as exercicioLote,  lote.id.lote as lote,  pagamento.sequenciaLote as sequenciaLote,  pagamentosDebito.estorno as estorno,  pessoa.id as pessoaId,  pessoa.nome as nome,  pagamento.dataMovimento as dataMovimento,  pagamento.dataPagamento as dataPagamento,  pagamento.valorPago as valorPago  %s  order by pagamento.id.entidade desc, pagamento.id.exercicioPagamento desc, pagamento.id.pagamento desc ", sqlFrom);
        String sqlCountForPage = String.format(" select count(distinct pagamentoBoleto.id) %s ", sqlFrom);
        TypedQuery queryCount = this.em.createQuery(sqlCountForPage, Long.class).setParameter(ENTIDADE, (Object)entidade);
        this.setFiltroDatas((Query)queryCount, filtroPagamento);
        Long quantidadeTotal = (Long)queryCount.getSingleResult();
        Query query = this.em.createQuery(sqlPagamentos).setParameter(ENTIDADE, (Object)entidade);
        this.setFiltroDatas(query, filtroPagamento);
        List result = ((org.hibernate.query.Query)query.setParameter(ENTIDADE, (Object)entidade).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).unwrap(org.hibernate.query.Query.class)).setResultTransformer(Transformers.aliasToBean(PagamentoDTO.class)).getResultList();
        return new PageImpl(result, pageable, quantidadeTotal.longValue());
    }

    public List<Pagamento> findPagamentos(Long entidade, FiltroPagamentoDTO filtroPagamento) {
        String sqlFrom = String.format(" from Pagamento pagamento  join pagamento.pagamentoBoleto pagamentoBoleto  join pagamentoBoleto.boleto boleto  join boleto.pessoa pessoa  join pagamento.lote lote  join pagamentoBoleto.pagamentosDebito pagamentosDebito  join pagamentosDebito.id.debitoParcelaTributo tributo  join tributo.debitoParcela debitoParcela  where pagamento.id.entidade = :entidade  %s ", filtroPagamento.buildFiltro());
        String sqlPagamentos = String.format("select distinct pagamento  %s order by pagamento.id.entidade desc, pagamento.id.exercicioPagamento desc, pagamento.id.pagamento desc ", sqlFrom);
        TypedQuery query = this.em.createQuery(sqlPagamentos, Pagamento.class).setParameter(ENTIDADE, (Object)entidade);
        this.setFiltroDatas((Query)query, filtroPagamento);
        return query.setParameter(ENTIDADE, (Object)entidade).getResultList();
    }

    private void setFiltroDatas(Query query, FiltroPagamentoDTO filtroPagamento) {
        Map filtros = filtroPagamento.getFiltroDatas();
        filtros.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }

    public Boolean existePagamentoNaoEstornadoParaMesmaParcelaTributo(Pagamento pagamento, DebitoParcelaTributo debitoParcelaTributo) {
        String sql = FileUtils.readResourceAsString((String)SQL_PAGAMENTOS_EXISTENTES_MESMA_PARCELA_TRIBUTO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)pagamento.getId().getEntidade());
        parameters.addValue("exercicio", (Object)pagamento.getId().getExercicioPagamento());
        parameters.addValue("pagamento", (Object)pagamento.getId().getPagamento());
        parameters.addValue("idDebitoParcelaTributo", (Object)debitoParcelaTributo.getId());
        return (Boolean)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getBoolean("exist"));
    }

    public List<DebitoIdDTO> findIdDebitoItbiListByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String tipoGuiaITBI = " AND TGR.TIPOGUIARECOLHIMENTO = 'T' ";
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_DEBITO_QUITADO_BY_PAGAMENTO), " AND TGR.TIPOGUIARECOLHIMENTO = 'T' ");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue("exerciciopagamento", (Object)exercicioPagamento);
        parameters.addValue("pagamento", (Object)pagamento);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }

    public List<DebitoIdDTO> findIdDebitoQuitadoListByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_DEBITO_QUITADO_BY_PAGAMENTO), "");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue("exerciciopagamento", (Object)exercicioPagamento);
        parameters.addValue("pagamento", (Object)pagamento);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }
}

