/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.CadastroGeralResponsavelDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.repository.CadastroGeralCustomRepository;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroGeralRepositoryImpl
implements CadastroGeralCustomRepository {
    private static final String CADASTROS_GERAL_COM_DEBITO = "br/com/elotech/tributos/repository/find-cadastros-geral-debito.sql";
    private static final String CADASTRO_GERAL_RESPONSAVEL = "br/com/elotech/tributos/repository/find-cadastro-geral-responsavel.sql";
    private static final String CADASTRO_GERAL_SOCIO_RESPONSAVEL = "br/com/elotech/tributos/repository/find-cadastro-geral-socio-responsavel.sql";
    private static final String CADASTRO_GERAL_POR_CPF_CNPJ = "br/com/elotech/tributos/repository/find-cadastro-por-cpf-cnpj.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public CadastroGeralRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<EnderecoCadastroGeralDTO> findCadastrosGeralByCadastro(Long cadastro) {
        String sql = FileUtils.readResourceAsString((String)CADASTROS_GERAL_COM_DEBITO);
        String sqlComFiltro = sql.replace("$[FILTROS]", " and endereco.cadastroGeral = :cadastro");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("cadastro", (Object)cadastro);
        return this.jdbcTemplate.query(sqlComFiltro, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EnderecoCadastroGeralDTO.class)).stream().sorted(Comparator.comparing(EnderecoCadastroGeralDTO::getTipoCadastro)).collect(Collectors.toList());
    }

    public List<EnderecoCadastroGeralDTO> findCadastrosGeralByPessoa(Long codigoPessoa) {
        String sql = FileUtils.readResourceAsString((String)CADASTROS_GERAL_COM_DEBITO);
        String sqlFiltro = " and exists(select 1 from TRIBCADASTROGERAL cadastro2 " + "                left outer join tribproprietario prop " + "                  on prop.tribcadastrogeral_idkey = cadastro2.idkey" + "               where cadastro.idkey = cadastro2.idkey " + "                 and (cadastro2.pessoa = :codigoPessoa or prop.pessoa = :codigoPessoa)) ";
        String sqlComFiltro = sql.replace("$[FILTROS]", sqlFiltro);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("codigoPessoa", (Object)codigoPessoa);
        return this.jdbcTemplate.query(sqlComFiltro, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EnderecoCadastroGeralDTO.class));
    }

    public List<CadastroGeralResponsavelDTO> findSocioMobiliario(Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_SOCIO_RESPONSAVEL);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroGeralResponsavelDTO.class));
    }

    public List<CadastroGeralResponsavelDTO> findProprietario(Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_RESPONSAVEL);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroGeralResponsavelDTO.class));
    }

    public Set<ParcelamentoCadastroDTO> getCadastrosByCpfCnpj(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_POR_CPF_CNPJ);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("cpfCnpj", (Object)cpfCnpj);
        List result = this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoCadastroDTO.class));
        return new HashSet<ParcelamentoCadastroDTO>(result);
    }
}

