/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.eventosituacaoparcela;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.repository.eventosituacaoparcela.EventoSituacaoParcelaCustomRepository;
import br.com.elotech.tributos.repository.eventosituacaoparcela.EventoSituacaoParcelaCustomRepositoryImpl;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EventoSituacaoParcelaCustomRepositoryImpl
implements EventoSituacaoParcelaCustomRepository {
    private static final Logger LOG = LoggerFactory.getLogger(EventoSituacaoParcelaCustomRepositoryImpl.class);
    private static final String SQL_FIND_TEXTO_VARIAVEL_POR_EVENTO = "select coalesce(textovariavel, '') as textovariavel from tribevento where evento = :evento";
    private static final String PARAMETRO_EVENTO = "evento";
    private static final String VARIAVEL_SITUACAOPARCELA = "$[EVENTO_SITUACAOPARCELA]";
    private static final String VARIAVEL_TIPOSITUACAOPARCELA = "$[EVENTO_TIPOSITUACAOPARCELA]";
    private static final String VARIAVEL_PAGOACERTO = "$[EVENTO_PAGOACERTO]";
    private static final String VARIAVEL_CANCELADOHOMOLOGACAOISS = "$[EVENTO_CANCELADOHOMOLOGACAOISS]";
    private static final String VARIAVEL_CANCELADOAUTOREVISADO = "$[EVENTO_CANCELADOAUTOREVISADO]";
    private static final String CIFRAO = "$";
    private static final String VALOR_TRUE = "S";
    private static final String VALOR_FALSE = "N";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public EventoSituacaoParcelaCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Optional<Long> getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum tipoEvento, SituacaoParcela situacaoParcela) {
        String textoVariavel = this.findTextoVariavelByEvento(tipoEvento).filter(StringUtils::isNotBlank).orElseThrow(() -> new EloValidationException(String.format("Evento %s n\u00e3o implementado.", tipoEvento.getDescricao())));
        String sql = this.substituiVariaveisAmbienteSql(tipoEvento, textoVariavel, situacaoParcela);
        if (sql.contains(CIFRAO)) {
            LOG.error("Erro ao substituir vari\u00e1veis no Evento {}: {}", (Object)tipoEvento.getDescricao(), (Object)sql);
            throw new EloValidationException(String.format("Erro ao substituir vari\u00e1veis no Evento %s", tipoEvento.getDescricao()));
        }
        try {
            return Optional.ofNullable(this.namedParameterJdbcTemplate.queryForObject(sql, new HashMap(), Long.class));
        }
        catch (EmptyResultDataAccessException e) {
            throw new EloValidationException(String.format("Nenhum registro encontrado para o evento %s", tipoEvento.getDescricao()));
        }
    }

    private Optional<String> findTextoVariavelByEvento(TipoEventoSituacaoParcelaEnum tipoEvento) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PARAMETRO_EVENTO, (Object)tipoEvento.getValue());
        return this.namedParameterJdbcTemplate.query(SQL_FIND_TEXTO_VARIAVEL_POR_EVENTO, (SqlParameterSource)params, (resultSet, rowNum) -> resultSet.getString("textovariavel")).stream().findFirst();
    }

    private String substituiVariaveisAmbienteSql(TipoEventoSituacaoParcelaEnum tipoEvento, String textoVariavel, SituacaoParcela situacaoParcela) {
        String sql = textoVariavel.replace(VARIAVEL_SITUACAOPARCELA, situacaoParcela.getId().toString()).replace(VARIAVEL_TIPOSITUACAOPARCELA, situacaoParcela.getTipoSituacaoParcela().getValue().toString());
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoEventoSituacaoParcelaEnum[tipoEvento.ordinal()]) {
            case 1: {
                return sql.replace(VARIAVEL_PAGOACERTO, VALOR_FALSE);
            }
            case 2: {
                return sql.replace(VARIAVEL_CANCELADOHOMOLOGACAOISS, VALOR_FALSE).replace(VARIAVEL_CANCELADOAUTOREVISADO, VALOR_FALSE);
            }
            case 3: {
                return sql.replace(VARIAVEL_PAGOACERTO, VALOR_TRUE);
            }
            case 4: {
                return sql.replace(VARIAVEL_CANCELADOHOMOLOGACAOISS, VALOR_TRUE);
            }
            case 5: {
                return sql.replace(VARIAVEL_CANCELADOAUTOREVISADO, VALOR_TRUE);
            }
        }
        return sql;
    }
}

