/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.jpa.hibernate.HibernateUtils;
import br.com.elotech.core.jpa.support.DialectWrapper;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.StatelessSession;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.SessionImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SequenceGeneratorRepository {
    private final JdbcTemplate jdbcTemplate;
    private final EntityManager em;

    public SequenceGeneratorRepository(JdbcTemplate jdbcTemplate, EntityManager em) {
        this.jdbcTemplate = jdbcTemplate;
        this.em = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextVal(String sequence) {
        SessionImpl session = (SessionImpl)this.em.unwrap(SessionImpl.class);
        Dialect dialect = HibernateUtils.getDialect((SessionImpl)session);
        String sqlSequenceNextVal = dialect.getSelectSequenceNextValString(sequence);
        if (!this.sequenceExists(dialect, sequence).booleanValue()) {
            DialectWrapper dialectWrapper = new DialectWrapper(dialect);
            String sqlCreateSequence = dialectWrapper.getCreateSequenceStrings(sequence, 2, 1);
            try (StatelessSession statelessSession = session.getFactory().openStatelessSession();){
                statelessSession.beginTransaction();
                statelessSession.createNativeQuery(sqlCreateSequence).executeUpdate();
                statelessSession.getTransaction().commit();
            }
            return 1L;
        }
        return (Long)this.jdbcTemplate.queryForObject("SELECT " + sqlSequenceNextVal + " FROM DUAL", new Object[0], Long.class);
    }

    private Boolean sequenceExists(Dialect dialect, String sequence) {
        String sqlSequenceQuery = dialect.getQuerySequencesString();
        List sequencesName = this.jdbcTemplate.queryForList(sqlSequenceQuery, new Object[0], String.class);
        return sequencesName.stream().anyMatch(sequence::equalsIgnoreCase);
    }
}

