/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ImobiliariaRepository
extends CrudRepository<Imobiliaria, Long> {
    public List<Imobiliaria> findByPessoaId(Long var1);

    public List<Imobiliaria> findByPessoaNome(String var1);

    @Query(value="SELECT     CG.CADASTROGERAL as cadastroGeral,     CG.IDCADASTROGERALISS as idCadastroGeralIss,     P.PESSOA as pessoa,     CG.TIPOCADASTRO as tipoCadastro,     CAST('IM' AS VARCHAR(2)) AS tipoVinculo FROM     PESSOA P JOIN TRIBCONTRATOSOCIALPESSOA CSP ON     P.PESSOA = CSP.PESSOA JOIN(         SELECT             MAX( SEQUENCIA ) AS SEQUENCIA,             TIPOCADASTRO,             CADASTROGERAL         FROM             TRIBCONTRATOSOCIAL         GROUP BY             TIPOCADASTRO,             CADASTROGERAL     ) CS ON     CS.TIPOCADASTRO = CSP.TIPOCADASTRO     AND CS.CADASTROGERAL = CSP.CADASTROGERAL     AND CS.SEQUENCIA = CSP.SEQUENCIA JOIN TRIBCADASTROGERAL CGM ON     CS.TIPOCADASTRO = CGM.TIPOCADASTRO     AND CS.CADASTROGERAL = CGM.CADASTROGERAL     AND CGM.EXCLUSAOLOGICA = 'N' JOIN TRIBIMOBILIARIA M ON     M.TIPOCADASTRO = CGM.TIPOCADASTRO     AND M.CADASTROGERAL = CGM.CADASTROGERAL JOIN TRIBIMOBILIARIACADASTRO MC ON     MC.IMOBILIARIA = M.IMOBILIARIA JOIN TRIBCADASTROGERAL CG ON     MC.TIPOCADASTRO = CG.TIPOCADASTRO     AND MC.CADASTROGERAL = CG.CADASTROGERAL     AND CG.EXCLUSAOLOGICA = 'N' WHERE P.CNPJ_CPF = ?1 ", nativeQuery=true)
    public Stream<CadastroGeralResponsavelProjection> findResponsavel(String var1);
}

