/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoEmAbertoRepository {
    private static final String SQL_DEBITOS = "br/com/elotech/tributos/repository/find-debito-aberto.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DebitoEmAbertoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoEmAbertoDTO> loadDebitoEmAberto(String filtro, Boolean somenteConstituidos) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SQL_DEBITOS)).append(" and ( ").append(filtro).append(" ) ");
        if (somenteConstituidos.booleanValue()) {
            sql.append(" and TRIBDEBITO.CONSTITUIDO = 'S'");
        }
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(DebitoEmAbertoDTO.class));
    }
}

