/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoCotaUnicaRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String SQL_DISPONIVEL_WEB = "br/com/elotech/tributos/repository/find-debito-disponivel-web.sql";

    public DebitoCotaUnicaRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoParcelaReceitaDisponivelWeb(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, LocalDate dataVencimento) {
        String sql = FileUtils.readResourceAsString((String)SQL_DISPONIVEL_WEB);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        parameters.addValue("dataVencimento", (Object)Date.valueOf(dataVencimento), 91);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaTributoCotaUnicaDTO.class));
    }
}

