/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.tributos.report.datasetrecord.CabecalhoDatasetRecord;
import br.com.elotech.tributos.report.datasetrecord.DebitoAutomaticoDatasetRecord;
import br.com.elotech.tributos.util.GeradorDigitoVerificador;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class DebitoAutomaticoParamLoader
implements ParamLoader {
    public static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    public static final String PARAM_EXERCICIO = "PExercicio";
    public static final String PARAM_DESC_UF = "PDescUF";
    public static final String PARAM_DIGITO = "PDigito";
    private final DebitoAutomaticoDatasetRecord record;

    public DebitoAutomaticoParamLoader(DebitoAutomaticoDatasetRecord record) {
        this.record = record;
    }

    public Set<Param> load(ReportDatasets datasets) {
        Dataset datasetCabecalho = (Dataset)datasets.get("Cabecalho");
        CabecalhoDatasetRecord cabecalho = (CabecalhoDatasetRecord)datasetCabecalho.getRecords().stream().findFirst().orElseThrow(() -> new RecordNotFoundException("N\u00e3o foi encontrado sub-relat\u00f3rio de cabe\u00e7alho no relat\u00f3rio."));
        HashSet params = Sets.newHashSet();
        params.add(Param.of((String)PARAM_NOME_ENTIDADE, (Object)cabecalho.getNome()));
        params.add(Param.of((String)PARAM_EXERCICIO, (Object)cabecalho.getExercicio()));
        params.add(Param.of((String)PARAM_DESC_UF, (Object)cabecalho.getDescuf()));
        params.add(Param.of((String)PARAM_DIGITO, (Object)this.getDigitoVerificador(this.record.getIdentificacaoOrigem())));
        return params;
    }

    private Integer getDigitoVerificador(String codigoSemDigitoVerificador) {
        return GeradorDigitoVerificador.geradorDigitoVerificadorMod11((String)codigoSemDigitoVerificador);
    }
}

