/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.ws.rest.dto.DebitoGenericDTO;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

public class DebitoDTO
extends DebitoGenericDTO {
    private String descricaoSituacao;
    private Boolean emiteBloqueto;
    private Long parcela;
    private String situacao;
    private Long idParcelamento;
    private Long numeroContrato;
    private Integer anoContrato;
    private String tipoContrato;
    private Boolean proprio;
    private Long idDebito;
    private Integer numeroParcelas;
    private List<DebitoDTO> debitos;
    private LocalDate vencimento;

    public Long getIdDebito() {
        return this.idDebito;
    }

    public String getDescricaoSituacao() {
        return this.descricaoSituacao;
    }

    public String getDescricaoVisualizacao() {
        if (this.contemNumeroContrato().booleanValue()) {
            return "Contrato (" + this.getNumeroContrato() + ") de parcelamento" + " - " + this.getAnoContrato();
        }
        return this.getFormatedDescricaoGuiaExercicio();
    }

    public String getDescricaoExercicio() {
        return this.getFormatedDescricaoGuiaExercicio();
    }

    private String getFormatedDescricaoGuiaExercicio() {
        if (this.contemDescricaoGuia().booleanValue()) {
            return String.format("%d %d-%s Sub-%d", this.getExercicio(), this.getGuiaRecolhimento(), this.getDescricaoGuia(), this.getSubDivida());
        }
        return null;
    }

    public void setDescricaoSituacao(String descricaoSituacao) {
        this.descricaoSituacao = descricaoSituacao;
    }

    public Boolean getEmiteBloqueto() {
        return this.emiteBloqueto;
    }

    public void setEmiteBloqueto(Boolean emiteBloqueto) {
        this.emiteBloqueto = emiteBloqueto;
    }

    public Long getParcela() {
        return this.parcela;
    }

    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public LocalDate getVencimento() {
        return this.vencimento;
    }

    public void setVencimento(LocalDate vencimento) {
        this.vencimento = vencimento;
    }

    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    public Boolean contemIdParcelamento() {
        return this.idParcelamento != null && this.idParcelamento != 0L;
    }

    public Boolean naoContemIdParcelamento() {
        return this.contemIdParcelamento() == false;
    }

    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    public Boolean contemNumeroContrato() {
        return this.numeroContrato != null && this.numeroContrato != 0L;
    }

    public Boolean naoContemNumeroContrato() {
        return this.contemNumeroContrato() == false;
    }

    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = anoContrato;
    }

    public String getTipoContrato() {
        return this.tipoContrato;
    }

    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    public List<DebitoDTO> getDebitos() {
        return this.debitos;
    }

    public void setDebitos(List<DebitoDTO> debitos) {
        this.debitos = debitos;
    }

    public void addDebito(DebitoDTO debito) {
        if (this.debitos == null) {
            this.debitos = Lists.newArrayList();
        }
        this.debitos.add(debito);
    }

    public void somaValor(DebitoDTO debito) {
        this.setValor(this.getValor().add(debito.getValor()));
    }

    public Boolean getProprio() {
        return this.proprio;
    }

    public void setProprio(Boolean proprio) {
        this.proprio = proprio;
    }

    public Boolean getVencido() {
        return DateUtils.isVencido((LocalDate)this.vencimento);
    }

    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    public void setNumeroParcelas(Integer numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoDTO)) {
            return false;
        }
        DebitoDTO other = (DebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$descricaoSituacao = this.getDescricaoSituacao();
        String other$descricaoSituacao = other.getDescricaoSituacao();
        if (this$descricaoSituacao == null ? other$descricaoSituacao != null : !this$descricaoSituacao.equals(other$descricaoSituacao)) {
            return false;
        }
        Boolean this$emiteBloqueto = this.getEmiteBloqueto();
        Boolean other$emiteBloqueto = other.getEmiteBloqueto();
        if (this$emiteBloqueto == null ? other$emiteBloqueto != null : !((Object)this$emiteBloqueto).equals(other$emiteBloqueto)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        Long this$idParcelamento = this.getIdParcelamento();
        Long other$idParcelamento = other.getIdParcelamento();
        if (this$idParcelamento == null ? other$idParcelamento != null : !((Object)this$idParcelamento).equals(other$idParcelamento)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        Boolean this$proprio = this.getProprio();
        Boolean other$proprio = other.getProprio();
        if (this$proprio == null ? other$proprio != null : !((Object)this$proprio).equals(other$proprio)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Integer this$numeroParcelas = this.getNumeroParcelas();
        Integer other$numeroParcelas = other.getNumeroParcelas();
        if (this$numeroParcelas == null ? other$numeroParcelas != null : !((Object)this$numeroParcelas).equals(other$numeroParcelas)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        LocalDate this$vencimento = this.getVencimento();
        LocalDate other$vencimento = other.getVencimento();
        return !(this$vencimento == null ? other$vencimento != null : !((Object)this$vencimento).equals(other$vencimento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $descricaoSituacao = this.getDescricaoSituacao();
        result = result * 59 + ($descricaoSituacao == null ? 43 : $descricaoSituacao.hashCode());
        Boolean $emiteBloqueto = this.getEmiteBloqueto();
        result = result * 59 + ($emiteBloqueto == null ? 43 : ((Object)$emiteBloqueto).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        Long $idParcelamento = this.getIdParcelamento();
        result = result * 59 + ($idParcelamento == null ? 43 : ((Object)$idParcelamento).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        Boolean $proprio = this.getProprio();
        result = result * 59 + ($proprio == null ? 43 : ((Object)$proprio).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Integer $numeroParcelas = this.getNumeroParcelas();
        result = result * 59 + ($numeroParcelas == null ? 43 : ((Object)$numeroParcelas).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        LocalDate $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : ((Object)$vencimento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoDTO(super=" + super.toString() + ", descricaoSituacao=" + this.getDescricaoSituacao() + ", emiteBloqueto=" + this.getEmiteBloqueto() + ", parcela=" + this.getParcela() + ", situacao=" + this.getSituacao() + ", idParcelamento=" + this.getIdParcelamento() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ", tipoContrato=" + this.getTipoContrato() + ", proprio=" + this.getProprio() + ", idDebito=" + this.getIdDebito() + ", numeroParcelas=" + this.getNumeroParcelas() + ", debitos=" + this.getDebitos() + ", vencimento=" + this.getVencimento() + ")";
    }
}

