/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.TipoLote;
import br.com.elotech.tributos.domain.Zoneamento;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAreaVerde;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAvaliacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioDesapropriacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioGeminada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCADASTROIMOBILIARIO")
@Audited
@PrimaryKeyJoinColumn(name="TRIBCADASTROGERAL_IDKEY")
@DynamicInsert
@DynamicUpdate
public class CadastroImobiliario
extends CadastroGeral {
    @Column(length=30)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral")
    private String inscricaoCadastral;
    @Column(length=50)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral Anterior")
    private String inscricaoCadastralAnterior;
    @Column(name="TRECHO_INSCRICAOCADASTRAL")
    @Caption(value="Trecho Inscri\u00e7\u00e3o Cadastral")
    private Long trechoInscricaoCadastral;
    @Column(length=20, name="QUADRA_INSCRICAOCADASTRAL")
    @Caption(value="Quadra Inscri\u00e7\u00e3o Cadastral")
    private String quadraInscricaoCadastral;
    @Column(length=20, name="LOTE_INSCRICAOCADASTRAL")
    @Caption(value="Lote Inscri\u00e7\u00e3o Cadastral")
    private String loteInscricaoCadastral;
    @ManyToOne
    @JoinColumn(name="DISTRITO_INSCRICAOCADASTRAL", referencedColumnName="DISTRITO")
    @Caption(value="Distrito Inscri\u00e7\u00e3o Cadastral")
    @NotAudited
    private Distrito distritoInscricaoCadastral;
    @ManyToOne
    @JoinColumn(name="TRIBSETOR_IDKEY")
    @Caption(value="Setor Inscri\u00e7\u00e3o Cadastral")
    @NotAudited
    private Setor setorInscricaoCadastral;
    @Column(length=15, name="UNIDADE_INSCRICAOCADASTRAL")
    @Caption(value="Unidade Inscri\u00e7\u00e3o Cadastral")
    private String unidadeInscricaoCadastral;
    @Column(length=15, name="DISTRITO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Distrito")
    private String distritoDescr;
    @Column(length=15, name="SETOR_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Setor")
    private String setorDescr;
    @Column(length=15, name="TRECHO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Trecho")
    private String trechoDescr;
    @Column(length=15, name="QUADRA_DESCR")
    @Caption(value="Quadra Setor")
    private String quadraDescr;
    @Column(length=15, name="LOTE_DESCR")
    @Caption(value="Lote Setor")
    private String loteDescr;
    @Column(length=15, name="UNIDADE_DESCR")
    @Caption(value="Unidade Setor")
    private String unidadeDescr;
    @ManyToOne
    @NotAudited
    private Imobiliaria imobiliaria;
    @ManyToOne
    @NotAudited
    @JoinColumn(name="TRIBCONDOMINIO_IDKEY")
    private Condominio condominio;
    @ManyToOne
    @JoinColumn(name="TRIBLOTEAMENTO_IDKEY")
    @NotAudited
    private Loteamento loteamento;
    private Long anoAliquotaProgressiva;
    @Min(value=1L)
    private @Min(value=1L) BigDecimal areaLote = BigDecimal.ZERO;
    private BigDecimal profundidadeMedia = BigDecimal.ZERO;
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Limita Cerca Muro")
    private Boolean limitaCercaMuro = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Im\u00f3vel Pr\u00f3prio")
    private Boolean imovelProprio = Boolean.FALSE;
    @Column(length=15)
    @Caption(value="Matr\u00edcula")
    private String matricula;
    @Column(length=60)
    @Caption(value="Cart\u00f3rio")
    private String cartorio;
    private LocalDate dataMatricula;
    @Column(length=15)
    @Caption(value="Livro")
    private String livro;
    @Column(length=15)
    @Caption(value="Folha")
    private String folha;
    @Column(length=15)
    @Caption(value="Face Quadra")
    private String faceQuadra;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Caucionado")
    private Boolean caucionado = Boolean.FALSE;
    @Column(length=60)
    @Caption(value="Latitude")
    private String latitude;
    @Column(length=60)
    @Caption(value="Longitude")
    private String longitude;
    private BigDecimal areaUnidadeConstruida = BigDecimal.ZERO;
    private BigDecimal areaUtilLote = BigDecimal.ZERO;
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    private BigDecimal areaComum = BigDecimal.ZERO;
    @Column(length=1000)
    @Caption(value="Complemento Lote")
    private String complementoLote;
    private TipoImovel tipoImovel = TipoImovel.TERRITORIAL;
    private Long notificacaoAliquotaProgressiva;
    private Long grauSul;
    private Long minutoSul;
    private BigDecimal segundoSul = BigDecimal.ZERO;
    private Long grauOeste;
    private Long minutoOeste;
    private BigDecimal segundoOeste = BigDecimal.ZERO;
    private LocalDate dataOficioAliquotaProgressiva;
    @Column(length=20)
    @Caption(value="N\u00famero Incra")
    private String numeroIncra;
    private TipoLote tipoLote;
    @Column(name="QUADRICULA_INSCRICAOCADASTRAL", length=10)
    @Caption(value="Quadr\u00edcula Inscri\u00e7\u00e3o Cadastral")
    private String quadriculaInscricaoCadastral;
    @Length(max=1)
    private @Length(max=1) String situacaoDesapropriado;
    @ManyToOne
    @JoinColumn(name="idzoneamento", referencedColumnName="idzoneamento")
    private Zoneamento zoneamento;
    @ManyToOne
    @JoinColumn(name="ideixo", referencedColumnName="ideixo")
    private Eixo eixo;
    @Column(name="QUADRICULA_DESCRI", length=15)
    @Caption(value="Descri\u00e7\u00e3o Quadr\u00edcula")
    private String quadriculaDescr;
    @Transient
    @NotAudited
    private SituacaoImobiliario situacaoImobiliario;
    @AuditJoinTable(name="TRIBIMOBSITUACAO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Situa\u00e7\u00f5es")
    private final List<CadastroImobiliarioSituacao> cadastroImobiliarioSituacoes = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="\u00c1reas Verdes")
    private final List<CadastroImobiliarioAreaVerde> cadastroImobiliarioAreasVerde = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBAVALIACAO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Avalia\u00e7\u00f5es")
    private final List<CadastroImobiliarioAvaliacao> cadastroImobiliarioAvaliacoes = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Desapropria\u00e7\u00f5es")
    private final List<CadastroImobiliarioDesapropriacao> cadastroImobiliarioDesapropriacoes = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBPROFUNDIDADE_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Profundidades")
    private final List<CadastroImobiliarioProfundidade> cadastroImobiliarioProfundidades = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBSEGMENTO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Segmentos")
    private final List<CadastroImobiliarioSegmento> cadastroImobiliarioSegmentos = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBTESTADA_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Testadas")
    private final List<CadastroImobiliarioTestada> cadastroImobiliarioTestadas = new ArrayList();
    @AuditJoinTable(name="TRIBBOLETIMIMOBTER_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Boletim Terreno")
    private final List<BoletimImobiliarioTerreno> boletinsImobiliarioTerreno = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Testada Gen\u00e9rica")
    private final List<CadastroImobiliarioTestadaGenerica> imobiliarioTestadasGenericas = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Geminadas")
    private final List<CadastroImobiliarioGeminada> imobiliarioGeminadas = new ArrayList();

    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    public String getInscricaoCadastralAnterior() {
        return this.inscricaoCadastralAnterior;
    }

    public Long getTrechoInscricaoCadastral() {
        return this.trechoInscricaoCadastral;
    }

    public String getQuadraInscricaoCadastral() {
        return this.quadraInscricaoCadastral;
    }

    public String getLoteInscricaoCadastral() {
        return this.loteInscricaoCadastral;
    }

    public Distrito getDistritoInscricaoCadastral() {
        return this.distritoInscricaoCadastral;
    }

    public Setor getSetorInscricaoCadastral() {
        return this.setorInscricaoCadastral;
    }

    public String getUnidadeInscricaoCadastral() {
        return this.unidadeInscricaoCadastral;
    }

    public String getDistritoDescr() {
        return this.distritoDescr;
    }

    public String getSetorDescr() {
        return this.setorDescr;
    }

    public String getTrechoDescr() {
        return this.trechoDescr;
    }

    public String getQuadraDescr() {
        return this.quadraDescr;
    }

    public String getLoteDescr() {
        return this.loteDescr;
    }

    public String getUnidadeDescr() {
        return this.unidadeDescr;
    }

    public Imobiliaria getImobiliaria() {
        return this.imobiliaria;
    }

    public Condominio getCondominio() {
        return this.condominio;
    }

    public Loteamento getLoteamento() {
        return this.loteamento;
    }

    public Long getAnoAliquotaProgressiva() {
        return this.anoAliquotaProgressiva;
    }

    public BigDecimal getAreaLote() {
        return this.areaLote;
    }

    public BigDecimal getProfundidadeMedia() {
        return this.profundidadeMedia;
    }

    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    public Boolean getLimitaCercaMuro() {
        return this.limitaCercaMuro;
    }

    public Boolean getImovelProprio() {
        return this.imovelProprio;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public String getCartorio() {
        return this.cartorio;
    }

    public LocalDate getDataMatricula() {
        return this.dataMatricula;
    }

    public String getLivro() {
        return this.livro;
    }

    public String getFolha() {
        return this.folha;
    }

    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    public Boolean getCaucionado() {
        return this.caucionado;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public BigDecimal getAreaUnidadeConstruida() {
        return this.areaUnidadeConstruida;
    }

    public BigDecimal getAreaUtilLote() {
        return this.areaUtilLote;
    }

    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    public String getComplementoLote() {
        return this.complementoLote;
    }

    public TipoImovel getTipoImovel() {
        return this.tipoImovel;
    }

    public Long getNotificacaoAliquotaProgressiva() {
        return this.notificacaoAliquotaProgressiva;
    }

    public Long getGrauSul() {
        return this.grauSul;
    }

    public Long getMinutoSul() {
        return this.minutoSul;
    }

    public BigDecimal getSegundoSul() {
        return this.segundoSul;
    }

    public Long getGrauOeste() {
        return this.grauOeste;
    }

    public Long getMinutoOeste() {
        return this.minutoOeste;
    }

    public BigDecimal getSegundoOeste() {
        return this.segundoOeste;
    }

    public LocalDate getDataOficioAliquotaProgressiva() {
        return this.dataOficioAliquotaProgressiva;
    }

    public String getNumeroIncra() {
        return this.numeroIncra;
    }

    public TipoLote getTipoLote() {
        return this.tipoLote;
    }

    public String getQuadriculaInscricaoCadastral() {
        return this.quadriculaInscricaoCadastral;
    }

    public String getSituacaoDesapropriado() {
        return this.situacaoDesapropriado;
    }

    public Zoneamento getZoneamento() {
        return this.zoneamento;
    }

    public Eixo getEixo() {
        return this.eixo;
    }

    public String getQuadriculaDescr() {
        return this.quadriculaDescr;
    }

    public List<CadastroImobiliarioSituacao> getCadastroImobiliarioSituacoes() {
        return this.cadastroImobiliarioSituacoes;
    }

    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    public void setInscricaoCadastralAnterior(String inscricaoCadastralAnterior) {
        this.inscricaoCadastralAnterior = inscricaoCadastralAnterior;
    }

    public void setTrechoInscricaoCadastral(Long trechoInscricaoCadastral) {
        this.trechoInscricaoCadastral = trechoInscricaoCadastral;
    }

    public void setQuadraInscricaoCadastral(String quadraInscricaoCadastral) {
        this.quadraInscricaoCadastral = quadraInscricaoCadastral;
    }

    public void setLoteInscricaoCadastral(String loteInscricaoCadastral) {
        this.loteInscricaoCadastral = loteInscricaoCadastral;
    }

    public void setDistritoInscricaoCadastral(Distrito distritoInscricaoCadastral) {
        this.distritoInscricaoCadastral = distritoInscricaoCadastral;
    }

    public void setSetorInscricaoCadastral(Setor setorInscricaoCadastral) {
        this.setorInscricaoCadastral = setorInscricaoCadastral;
    }

    public void setUnidadeInscricaoCadastral(String unidadeInscricaoCadastral) {
        this.unidadeInscricaoCadastral = unidadeInscricaoCadastral;
    }

    public void setDistritoDescr(String distritoDescr) {
        this.distritoDescr = distritoDescr;
    }

    public void setSetorDescr(String setorDescr) {
        this.setorDescr = setorDescr;
    }

    public void setTrechoDescr(String trechoDescr) {
        this.trechoDescr = trechoDescr;
    }

    public void setQuadraDescr(String quadraDescr) {
        this.quadraDescr = quadraDescr;
    }

    public void setLoteDescr(String loteDescr) {
        this.loteDescr = loteDescr;
    }

    public void setUnidadeDescr(String unidadeDescr) {
        this.unidadeDescr = unidadeDescr;
    }

    public void setImobiliaria(Imobiliaria imobiliaria) {
        this.imobiliaria = imobiliaria;
    }

    public void setCondominio(Condominio condominio) {
        this.condominio = condominio;
    }

    public void setLoteamento(Loteamento loteamento) {
        this.loteamento = loteamento;
    }

    public void setAnoAliquotaProgressiva(Long anoAliquotaProgressiva) {
        this.anoAliquotaProgressiva = anoAliquotaProgressiva;
    }

    public void setAreaLote(BigDecimal areaLote) {
        this.areaLote = areaLote;
    }

    public void setProfundidadeMedia(BigDecimal profundidadeMedia) {
        this.profundidadeMedia = profundidadeMedia;
    }

    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    public void setLimitaCercaMuro(Boolean limitaCercaMuro) {
        this.limitaCercaMuro = limitaCercaMuro;
    }

    public void setImovelProprio(Boolean imovelProprio) {
        this.imovelProprio = imovelProprio;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public void setCartorio(String cartorio) {
        this.cartorio = cartorio;
    }

    public void setDataMatricula(LocalDate dataMatricula) {
        this.dataMatricula = dataMatricula;
    }

    public void setLivro(String livro) {
        this.livro = livro;
    }

    public void setFolha(String folha) {
        this.folha = folha;
    }

    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    public void setCaucionado(Boolean caucionado) {
        this.caucionado = caucionado;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setAreaUnidadeConstruida(BigDecimal areaUnidadeConstruida) {
        this.areaUnidadeConstruida = areaUnidadeConstruida;
    }

    public void setAreaUtilLote(BigDecimal areaUtilLote) {
        this.areaUtilLote = areaUtilLote;
    }

    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    public void setComplementoLote(String complementoLote) {
        this.complementoLote = complementoLote;
    }

    public void setTipoImovel(TipoImovel tipoImovel) {
        this.tipoImovel = tipoImovel;
    }

    public void setNotificacaoAliquotaProgressiva(Long notificacaoAliquotaProgressiva) {
        this.notificacaoAliquotaProgressiva = notificacaoAliquotaProgressiva;
    }

    public void setGrauSul(Long grauSul) {
        this.grauSul = grauSul;
    }

    public void setMinutoSul(Long minutoSul) {
        this.minutoSul = minutoSul;
    }

    public void setSegundoSul(BigDecimal segundoSul) {
        this.segundoSul = segundoSul;
    }

    public void setGrauOeste(Long grauOeste) {
        this.grauOeste = grauOeste;
    }

    public void setMinutoOeste(Long minutoOeste) {
        this.minutoOeste = minutoOeste;
    }

    public void setSegundoOeste(BigDecimal segundoOeste) {
        this.segundoOeste = segundoOeste;
    }

    public void setDataOficioAliquotaProgressiva(LocalDate dataOficioAliquotaProgressiva) {
        this.dataOficioAliquotaProgressiva = dataOficioAliquotaProgressiva;
    }

    public void setNumeroIncra(String numeroIncra) {
        this.numeroIncra = numeroIncra;
    }

    public void setTipoLote(TipoLote tipoLote) {
        this.tipoLote = tipoLote;
    }

    public void setQuadriculaInscricaoCadastral(String quadriculaInscricaoCadastral) {
        this.quadriculaInscricaoCadastral = quadriculaInscricaoCadastral;
    }

    public void setSituacaoDesapropriado(String situacaoDesapropriado) {
        this.situacaoDesapropriado = situacaoDesapropriado;
    }

    public void setZoneamento(Zoneamento zoneamento) {
        this.zoneamento = zoneamento;
    }

    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    public void setQuadriculaDescr(String quadriculaDescr) {
        this.quadriculaDescr = quadriculaDescr;
    }

    public List<CadastroImobiliarioAreaVerde> getCadastroImobiliarioAreasVerde() {
        return this.cadastroImobiliarioAreasVerde;
    }

    public List<CadastroImobiliarioAvaliacao> getCadastroImobiliarioAvaliacoes() {
        return this.cadastroImobiliarioAvaliacoes;
    }

    public List<CadastroImobiliarioDesapropriacao> getCadastroImobiliarioDesapropriacoes() {
        return this.cadastroImobiliarioDesapropriacoes;
    }

    public List<CadastroImobiliarioProfundidade> getCadastroImobiliarioProfundidades() {
        return this.cadastroImobiliarioProfundidades;
    }

    public List<CadastroImobiliarioSegmento> getCadastroImobiliarioSegmentos() {
        return this.cadastroImobiliarioSegmentos;
    }

    public List<CadastroImobiliarioTestada> getCadastroImobiliarioTestadas() {
        return this.cadastroImobiliarioTestadas;
    }

    public List<BoletimImobiliarioTerreno> getBoletinsImobiliarioTerreno() {
        return this.boletinsImobiliarioTerreno;
    }

    public List<CadastroImobiliarioTestadaGenerica> getImobiliarioTestadasGenericas() {
        return this.imobiliarioTestadasGenericas;
    }

    public SituacaoImobiliario getSituacaoImobiliario() {
        return this.situacaoImobiliario;
    }

    public void setSituacaoImobiliario(SituacaoImobiliario situacaoImobiliario) {
        this.situacaoImobiliario = situacaoImobiliario;
    }

    public List<CadastroImobiliarioGeminada> getImobiliarioGeminadas() {
        return this.imobiliarioGeminadas;
    }

    public CadastroImobiliarioSituacao getSituacaoAtual() {
        for (CadastroImobiliarioSituacao situacao : this.cadastroImobiliarioSituacoes) {
            if (!situacao.getAtual().booleanValue()) continue;
            return situacao;
        }
        return null;
    }

    public boolean existsBoletimSegmento() {
        return this.getCadastroImobiliarioSegmentos().stream().filter(segmento -> !segmento.getBoletinsImobiliarioSegmento().isEmpty()).anyMatch(arg_0 -> this.existeBoletimSegmento(arg_0));
    }

    private boolean existeBoletimSegmento(CadastroImobiliarioSegmento segmento) {
        return !segmento.getBoletinsImobiliarioSegmento().isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliario)) {
            return false;
        }
        CadastroImobiliario other = (CadastroImobiliario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliario;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

