/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Setor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribLoteamento")
public class Loteamento
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBLOTEAMENTO_ID")
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="TRIBSETOR_IDKEY")
    @MetaModelIgnore
    private Setor setor;
    @Column(name="loteamento")
    @EloSequence(sequenceName="s05Loteamento_#{setor.distrito.distrito}_#{setor.setor}")
    private Long loteamento;
    @Length(max=60)
    @Caption(value="Descri\u00e7\u00e3o")
    private @Length(max=60) String descricao;
    @Caption(value="Loteador")
    private Long loteador;
    @Caption(value="Propriet\u00e1rio")
    private Long proprietario;
    @Length(max=60)
    @Caption(value="Apelido")
    private @Length(max=60) String apelido;
    @Caption(value="Numero Lotes")
    private Long numeroLotes;
    @Caption(value="Numero Quadras")
    private Long numeroQuadras;
    @Caption(value="\u00c1rea Loteada")
    private BigDecimal areaLoteada = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Sistema Vi\u00e1rio")
    private BigDecimal areaSistemaViario = BigDecimal.ZERO;
    @Length(max=60)
    @Caption(value="Gleba")
    private @Length(max=60) String gleba;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Irregular")
    private Boolean irregular = Boolean.FALSE;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    @Length(max=15)
    private @Length(max=15) String usuario;

    public Loteamento withPk(Long loteamento) {
        this.setId(loteamento);
        return this;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getApelido() {
        return this.apelido;
    }

    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    public Long getNumeroLotes() {
        return this.numeroLotes;
    }

    public void setNumeroLotes(Long numeroLotes) {
        this.numeroLotes = numeroLotes;
    }

    public Long getNumeroQuadras() {
        return this.numeroQuadras;
    }

    public void setNumeroQuadras(Long numeroQuadras) {
        this.numeroQuadras = numeroQuadras;
    }

    public BigDecimal getAreaLoteada() {
        return this.areaLoteada;
    }

    public void setAreaLoteada(BigDecimal areaLoteada) {
        this.areaLoteada = areaLoteada;
    }

    public String getGleba() {
        return this.gleba;
    }

    public void setGleba(String gleba) {
        this.gleba = gleba;
    }

    public Boolean getIrregular() {
        return this.irregular;
    }

    public void setIrregular(Boolean irregular) {
        this.irregular = irregular;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setAreaSistemaViario(BigDecimal areaSistemaViario) {
        this.areaSistemaViario = areaSistemaViario;
    }

    public Long getLoteador() {
        return this.loteador;
    }

    public void setLoteador(Long loteador) {
        this.loteador = loteador;
    }

    public Long getProprietario() {
        return this.proprietario;
    }

    public void setProprietario(Long proprietario) {
        this.proprietario = proprietario;
    }

    public BigDecimal getAreaSistemaViario() {
        return this.areaSistemaViario;
    }

    public Long getId() {
        return this.id;
    }

    public Setor getSetor() {
        return this.setor;
    }

    public Long getLoteamento() {
        return this.loteamento;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    public void setLoteamento(Long loteamento) {
        this.loteamento = loteamento;
    }

    public boolean isNew() {
        return Objects.nonNull(this.getId()) && Objects.nonNull(this.getSetor()) && Objects.nonNull(this.getLoteamento());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Loteamento)) {
            return false;
        }
        Loteamento other = (Loteamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Loteamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

