/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceId;
import br.com.elotech.tributos.domain.SituacaoLegal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DiscriminatorOptions;

@Entity
@Table(name="TRIBENTIDADECORRECAOINDICE")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(discriminatorType=DiscriminatorType.STRING, name="indice")
@DiscriminatorOptions(force=true, insert=false)
public class EntidadeCorrecaoIndice
implements EloEntity<EntidadeCorrecaoIndiceId>,
Serializable {
    @EmbeddedId
    private EntidadeCorrecaoIndiceId id;
    private Boolean emAberto;
    private Boolean dividaAtiva;
    private Boolean emJuizo;
    @MapsId(value="entidade,exercicio,sequencia")
    @MetaModelIgnore
    @OneToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="sequencia", referencedColumnName="sequencia", updatable=false)})
    private EntidadeCorrecao entidadeCorrecao;

    public EntidadeCorrecaoIndiceId getId() {
        return this.id;
    }

    public void setId(EntidadeCorrecaoIndiceId id) {
        this.id = id;
    }

    public Boolean incideNaSituacao(SituacaoLegal situacaoLegal) {
        return SituacaoLegal.NO_EXERCICIO.equals((Object)situacaoLegal) && this.emAberto != false || SituacaoLegal.DIVIDA_ATIVA.equals((Object)situacaoLegal) && this.dividaAtiva != false || SituacaoLegal.JUIZO.equals((Object)situacaoLegal) && this.emJuizo != false;
    }

    @Generated
    public String toString() {
        return "EntidadeCorrecaoIndice(id=" + this.getId() + ", emAberto=" + this.getEmAberto() + ", dividaAtiva=" + this.getDividaAtiva() + ", emJuizo=" + this.getEmJuizo() + ", entidadeCorrecao=" + this.getEntidadeCorrecao() + ")";
    }

    @Generated
    public Boolean getEmAberto() {
        return this.emAberto;
    }

    @Generated
    public Boolean getDividaAtiva() {
        return this.dividaAtiva;
    }

    @Generated
    public Boolean getEmJuizo() {
        return this.emJuizo;
    }

    @Generated
    public EntidadeCorrecao getEntidadeCorrecao() {
        return this.entidadeCorrecao;
    }

    @Generated
    public void setEmAberto(Boolean emAberto) {
        this.emAberto = emAberto;
    }

    @Generated
    public void setDividaAtiva(Boolean dividaAtiva) {
        this.dividaAtiva = dividaAtiva;
    }

    @Generated
    public void setEmJuizo(Boolean emJuizo) {
        this.emJuizo = emJuizo;
    }

    @Generated
    public void setEntidadeCorrecao(EntidadeCorrecao entidadeCorrecao) {
        this.entidadeCorrecao = entidadeCorrecao;
    }
}

