/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DocumentoTexto;
import br.com.elotech.tributos.domain.DocumentoTipoAssinatura;
import br.com.elotech.tributos.domain.DocumentoTipoOutros;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoValidadeDocumento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBDOCUMENTOTIPO")
public class DocumentoTipo
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence
    @Column(name="tipodocumento")
    private Long id;
    @Length(max=50)
    private @Length(max=50) String descricao;
    private Boolean impressaoWeb;
    private Boolean porCadastroGeral;
    private Boolean inativo = Boolean.FALSE;
    private Boolean exigeProcesso;
    @ElementCollection
    @CollectionTable(name="TRIBDOCUMENTOTIPOCADASTRO", joinColumns={@JoinColumn(name="tipodocumento")})
    @Column(name="tipocadastro")
    private List<TipoCadastro> tiposCadastro;
    @OneToMany
    @JoinColumn(name="tipodocumento", referencedColumnName="tipoDocumento")
    private List<DocumentoTipoAssinatura> assinaturas = new ArrayList();
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento"})
    private List<DocumentoTexto> textos = new ArrayList();
    @OneToMany(mappedBy="tipoDocumento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"tipoDocumento"})
    private List<DocumentoTipoOutros> outros = new ArrayList();
    @ManyToMany
    @JoinTable(name="TRIBDOCUMENTOTIPORELATORIO", joinColumns={@JoinColumn(name="tipodocumento")}, inverseJoinColumns={@JoinColumn(name="relatorio", referencedColumnName="relatorio"), @JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio")})
    private List<Relatorio> relatorios = new ArrayList();
    private Boolean geraDocumentoCentral;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio"), @JoinColumn(name="relatorio", referencedColumnName="relatorio")})
    private Relatorio relatorio;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="tribdocumentogrupotipo", joinColumns={@JoinColumn(name="tipodocumento", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="grupodocumento")})
    private List<GrupoDocumento> gruposDocumento = new ArrayList();
    private Integer validadeDia;
    private LocalDate validadeData;
    private TipoValidadeDocumento validade;

    @Generated
    public String toString() {
        return "DocumentoTipo(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoTipo)) {
            return false;
        }
        DocumentoTipo other = (DocumentoTipo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoTipo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public DocumentoTipo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getImpressaoWeb() {
        return this.impressaoWeb;
    }

    @Generated
    public Boolean getPorCadastroGeral() {
        return this.porCadastroGeral;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public Boolean getExigeProcesso() {
        return this.exigeProcesso;
    }

    @Generated
    public List<TipoCadastro> getTiposCadastro() {
        return this.tiposCadastro;
    }

    @Generated
    public List<DocumentoTipoAssinatura> getAssinaturas() {
        return this.assinaturas;
    }

    @Generated
    public List<DocumentoTexto> getTextos() {
        return this.textos;
    }

    @Generated
    public List<DocumentoTipoOutros> getOutros() {
        return this.outros;
    }

    @Generated
    public List<Relatorio> getRelatorios() {
        return this.relatorios;
    }

    @Generated
    public Boolean getGeraDocumentoCentral() {
        return this.geraDocumentoCentral;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public List<GrupoDocumento> getGruposDocumento() {
        return this.gruposDocumento;
    }

    @Generated
    public Integer getValidadeDia() {
        return this.validadeDia;
    }

    @Generated
    public LocalDate getValidadeData() {
        return this.validadeData;
    }

    @Generated
    public TipoValidadeDocumento getValidade() {
        return this.validade;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setImpressaoWeb(Boolean impressaoWeb) {
        this.impressaoWeb = impressaoWeb;
    }

    @Generated
    public void setPorCadastroGeral(Boolean porCadastroGeral) {
        this.porCadastroGeral = porCadastroGeral;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setExigeProcesso(Boolean exigeProcesso) {
        this.exigeProcesso = exigeProcesso;
    }

    @Generated
    public void setTiposCadastro(List<TipoCadastro> tiposCadastro) {
        this.tiposCadastro = tiposCadastro;
    }

    @Generated
    public void setAssinaturas(List<DocumentoTipoAssinatura> assinaturas) {
        this.assinaturas = assinaturas;
    }

    @Generated
    public void setTextos(List<DocumentoTexto> textos) {
        this.textos = textos;
    }

    @Generated
    public void setOutros(List<DocumentoTipoOutros> outros) {
        this.outros = outros;
    }

    @Generated
    public void setRelatorios(List<Relatorio> relatorios) {
        this.relatorios = relatorios;
    }

    @Generated
    public void setGeraDocumentoCentral(Boolean geraDocumentoCentral) {
        this.geraDocumentoCentral = geraDocumentoCentral;
    }

    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setGruposDocumento(List<GrupoDocumento> gruposDocumento) {
        this.gruposDocumento = gruposDocumento;
    }

    @Generated
    public void setValidadeDia(Integer validadeDia) {
        this.validadeDia = validadeDia;
    }

    @Generated
    public void setValidadeData(LocalDate validadeData) {
        this.validadeData = validadeData;
    }

    @Generated
    public void setValidade(TipoValidadeDocumento validade) {
        this.validade = validade;
    }
}

