/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaFormaPagamentoParcela;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.service.exception.DividaFormaPagamentoException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;

@Entity
@Table(name="tribguiarecolhimentoformapag")
public class DividaFormaPagamento
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBGUIARECOLHIMENTOFORMAPAG")
    private Long id;
    @NotNull(message="Entidade \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Entidade \u00e9 obrigat\u00f3ria") Long entidade;
    @NotNull(message="Exercicio \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Exercicio \u00e9 obrigat\u00f3rio") Long exercicio;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria") Long guiaRecolhimento;
    private LocalDate vencimento;
    private Long validade;
    @ManyToOne
    @JoinColumn(name="modelobloqueto")
    @IgnoreSizeOf
    private ModeloBoleto modeloBoleto;
    private LocalDate limiteEmissao;
    @ManyToOne
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    @IgnoreSizeOf
    private MotivoDeducao motivoDeducao;
    private Boolean disponivelWeb;
    @NotNull
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne
    @JoinColumn(name="TRIBGUIARECOLHIMENTO_IDKEY")
    @IgnoreSizeOf
    private Divida divida;
    @NotNull(message="Forma de pagamento \u00e9 obrigat\u00f3ria")
    @ManyToOne
    @JoinColumn(name="formaPagamento")
    @IgnoreSizeOf
    private @NotNull(message="Forma de pagamento \u00e9 obrigat\u00f3ria") FormaPagamento formaPagamento;
    @OneToMany(mappedBy="dividaFormaPagamento")
    @IgnoreSizeOf
    private List<DividaFormaPagamentoTributo> formasPagamentoTributo = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento", updatable=false), @JoinColumn(name="formapagamento", referencedColumnName="formapagamento", updatable=false)})
    @IgnoreSizeOf
    @JsonIgnoreProperties(value={"dividaFormaPagamento"})
    private List<DividaFormaPagamentoParcela> parcelas = new ArrayList();

    public void validaFormaPagamentoWeb() {
        if (this.getDisponivelWeb().booleanValue() && TipoFormaPagamento.COTA_UNICA.equals((Object)this.getFormaPagamento().getTipoFormaPagamento()) && this.getVencimento().compareTo(LocalDate.now()) < 0) {
            throw DividaFormaPagamentoException.vencimentoAnteriorAtual((Long)this.getFormaPagamento().getId());
        }
    }

    public void setRelationsKeys() {
        this.getParcelas().stream().forEach(parcela -> {
            parcela.setEntidade(this.entidade);
            parcela.setExercicio(this.exercicio);
            parcela.setFormaPagamento(this.formaPagamento.getId());
            parcela.setGuiaRecolhimento(this.guiaRecolhimento);
        });
        if (Objects.nonNull(this.getFormasPagamentoTributo())) {
            this.getFormasPagamentoTributo().forEach(tributo -> {
                tributo.getId().setEntidade(this.getEntidade());
                tributo.getId().setExercicio(this.getExercicio());
                tributo.getId().setDivida(this.getDivida().getDivida());
                tributo.getId().setFormaPagamento(this.getFormaPagamento().getId());
            });
        }
    }

    public Boolean existeTributoDividaFormaPagamentoTributo(String tributo) {
        return this.getFormasPagamentoTributo().stream().anyMatch(formaPagamentoTributo -> formaPagamentoTributo.getTributo().getTributo().equals(tributo));
    }

    public Boolean existeDividaFormaPagamentoTributoDividaTributo(DividaFormaPagamentoTributo dividaFormaPagamentoTributo) {
        return this.getDivida().getTributos().stream().anyMatch(tributo -> tributo.getTributo().getTributo().equals(dividaFormaPagamentoTributo.getTributo().getTributo()));
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public LocalDate getVencimento() {
        return this.vencimento;
    }

    @Generated
    public Long getValidade() {
        return this.validade;
    }

    @Generated
    public ModeloBoleto getModeloBoleto() {
        return this.modeloBoleto;
    }

    @Generated
    public LocalDate getLimiteEmissao() {
        return this.limiteEmissao;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public Boolean getDisponivelWeb() {
        return this.disponivelWeb;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public List<DividaFormaPagamentoTributo> getFormasPagamentoTributo() {
        return this.formasPagamentoTributo;
    }

    @Generated
    public List<DividaFormaPagamentoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setVencimento(LocalDate vencimento) {
        this.vencimento = vencimento;
    }

    @Generated
    public void setValidade(Long validade) {
        this.validade = validade;
    }

    @Generated
    public void setModeloBoleto(ModeloBoleto modeloBoleto) {
        this.modeloBoleto = modeloBoleto;
    }

    @Generated
    public void setLimiteEmissao(LocalDate limiteEmissao) {
        this.limiteEmissao = limiteEmissao;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setDisponivelWeb(Boolean disponivelWeb) {
        this.disponivelWeb = disponivelWeb;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setFormasPagamentoTributo(List<DividaFormaPagamentoTributo> formasPagamentoTributo) {
        this.formasPagamentoTributo = formasPagamentoTributo;
    }

    @Generated
    public void setParcelas(List<DividaFormaPagamentoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DividaFormaPagamento)) {
            return false;
        }
        DividaFormaPagamento other = (DividaFormaPagamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DividaFormaPagamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

