/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.DebitoParcelaObservacaoId;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.SituacaoLegal;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribdebitoparcela")
public class DebitoParcela
implements EloEntity<DebitoParcelaId>,
Serializable {
    @EmbeddedId
    private DebitoParcelaId id;
    private SituacaoLegal situacaoLegal = SituacaoLegal.NO_EXERCICIO;
    @ManyToOne
    private SituacaoParcela situacaoDebito;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private LocalDate dataSituacao;
    private LocalDate dataDividaAtiva;
    private Long tipoCalculoDebito = 0L;
    private Long calculo = 0L;
    private Long exercicioLivro;
    private Long livro;
    private Long numeroFolha;
    private Long numeroInscricao;
    private LocalDate dataDistribuicao;
    private Long numeroDistribuicao;
    private Long idCartorio;
    private Long qtdeParcelada;
    private Long situacaoNina;
    private Long existeCadastro;
    private Long situacaoAntiga;
    private Long lote;
    private LocalDate dataMovimento;
    private Long valorPago;
    private Long valorCalculado;
    private Long anoReferencia;
    private Long mesReferencia;
    @EloSequence(sequenceName="S05DEBITOPARCELARECEITAID")
    private Long idDebitoParcela;
    @Length(max=30, message="Tamanho m\u00e1ximo \u00e9 30")
    private @Length(max=30, message="Tamanho m\u00e1ximo \u00e9 30") String processoJudicial;
    private LocalDate dataAjuizamento;
    private Long idProtesto;
    @OneToMany(mappedBy="debitoParcela")
    private List<DebitoParcelaTributo> tributos = new ArrayList();
    @OneToMany(mappedBy="debitoParcela", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoParcelaObservacao> observacoes = new ArrayList();
    @MapsId(value="entidade,exercicio,tipocadastro,cadastrogeral,divida,subdivida")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida")})
    private Debito debito;

    public void updateDadosParcelas(DebitoDetalheParcelasDTO debitoDetalheParcelasDTO) {
        this.setMesReferencia(debitoDetalheParcelasDTO.getMesReferencia());
        this.setAnoReferencia(debitoDetalheParcelasDTO.getAnoReferencia());
        this.setIdCartorio(debitoDetalheParcelasDTO.getIdCartorio());
        this.setNumeroDistribuicao(debitoDetalheParcelasDTO.getNumeroDistribuicao());
        this.setLivro(debitoDetalheParcelasDTO.getNumeroLivro());
        this.setExercicioLivro(debitoDetalheParcelasDTO.getExercicioLivroId());
        this.setNumeroFolha(debitoDetalheParcelasDTO.getNumeroFolha());
        this.setNumeroInscricao(debitoDetalheParcelasDTO.getNumeroInscricao());
        this.setDataAjuizamento(debitoDetalheParcelasDTO.getDataAjuizamento());
        this.setProcessoJudicial(debitoDetalheParcelasDTO.getProcessoJudicial());
    }

    public BigDecimal getValorTotal() {
        return this.tributos.stream().map(DebitoParcelaTributo::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public Long getNextSequenceObservacao() {
        return this.observacoes.stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getId().getSequencia())).map(DebitoParcelaObservacao::getId).map(DebitoParcelaObservacaoId::getSequencia).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }

    @JsonIgnore
    public void setObservacoesId() {
        for (DebitoParcelaObservacao debitoParcelaObservacao : this.observacoes) {
            if (Objects.isNull(debitoParcelaObservacao.getId())) {
                DebitoParcelaObservacaoId debitoParcelaObservacaoId = new DebitoParcelaObservacaoId();
                debitoParcelaObservacaoId.setSequencia(this.getNextSequenceObservacao());
                debitoParcelaObservacao.setId(debitoParcelaObservacaoId);
            }
            debitoParcelaObservacao.getId().setEntidade(this.id.getEntidade());
            debitoParcelaObservacao.getId().setExercicio(this.id.getExercicio());
            debitoParcelaObservacao.getId().setTipoCadastro(this.id.getTipoCadastro());
            debitoParcelaObservacao.getId().setCadastroGeral(this.id.getCadastroGeral());
            debitoParcelaObservacao.getId().setDivida(this.id.getDivida());
            debitoParcelaObservacao.getId().setSubDivida(this.id.getSubDivida());
            debitoParcelaObservacao.getId().setParcela(this.id.getParcela());
        }
    }

    @JsonIgnore
    public List<DebitoParcelaTributo> getTributosValorMaiorQueZero() {
        return this.getTributos().stream().filter(tributo -> tributo.getValor().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
    }

    public void setDebitoAndUpdateIdParcela(Debito debito) {
        this.setDebito(debito);
        this.getId().setParcela(debito.getNextNumeroParcela());
        this.setObservacoesId();
    }

    @Generated
    public DebitoParcela() {
    }

    @Generated
    public DebitoParcelaId getId() {
        return this.id;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public SituacaoParcela getSituacaoDebito() {
        return this.situacaoDebito;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public LocalDate getDataDividaAtiva() {
        return this.dataDividaAtiva;
    }

    @Generated
    public Long getTipoCalculoDebito() {
        return this.tipoCalculoDebito;
    }

    @Generated
    public Long getCalculo() {
        return this.calculo;
    }

    @Generated
    public Long getExercicioLivro() {
        return this.exercicioLivro;
    }

    @Generated
    public Long getLivro() {
        return this.livro;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public LocalDate getDataDistribuicao() {
        return this.dataDistribuicao;
    }

    @Generated
    public Long getNumeroDistribuicao() {
        return this.numeroDistribuicao;
    }

    @Generated
    public Long getIdCartorio() {
        return this.idCartorio;
    }

    @Generated
    public Long getQtdeParcelada() {
        return this.qtdeParcelada;
    }

    @Generated
    public Long getSituacaoNina() {
        return this.situacaoNina;
    }

    @Generated
    public Long getExisteCadastro() {
        return this.existeCadastro;
    }

    @Generated
    public Long getSituacaoAntiga() {
        return this.situacaoAntiga;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public Long getValorPago() {
        return this.valorPago;
    }

    @Generated
    public Long getValorCalculado() {
        return this.valorCalculado;
    }

    @Generated
    public Long getAnoReferencia() {
        return this.anoReferencia;
    }

    @Generated
    public Long getMesReferencia() {
        return this.mesReferencia;
    }

    @Generated
    public Long getIdDebitoParcela() {
        return this.idDebitoParcela;
    }

    @Generated
    public String getProcessoJudicial() {
        return this.processoJudicial;
    }

    @Generated
    public LocalDate getDataAjuizamento() {
        return this.dataAjuizamento;
    }

    @Generated
    public Long getIdProtesto() {
        return this.idProtesto;
    }

    @Generated
    public List<DebitoParcelaTributo> getTributos() {
        return this.tributos;
    }

    @Generated
    public List<DebitoParcelaObservacao> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public void setId(DebitoParcelaId id) {
        this.id = id;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setSituacaoDebito(SituacaoParcela situacaoDebito) {
        this.situacaoDebito = situacaoDebito;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setDataDividaAtiva(LocalDate dataDividaAtiva) {
        this.dataDividaAtiva = dataDividaAtiva;
    }

    @Generated
    public void setTipoCalculoDebito(Long tipoCalculoDebito) {
        this.tipoCalculoDebito = tipoCalculoDebito;
    }

    @Generated
    public void setCalculo(Long calculo) {
        this.calculo = calculo;
    }

    @Generated
    public void setExercicioLivro(Long exercicioLivro) {
        this.exercicioLivro = exercicioLivro;
    }

    @Generated
    public void setLivro(Long livro) {
        this.livro = livro;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setDataDistribuicao(LocalDate dataDistribuicao) {
        this.dataDistribuicao = dataDistribuicao;
    }

    @Generated
    public void setNumeroDistribuicao(Long numeroDistribuicao) {
        this.numeroDistribuicao = numeroDistribuicao;
    }

    @Generated
    public void setIdCartorio(Long idCartorio) {
        this.idCartorio = idCartorio;
    }

    @Generated
    public void setQtdeParcelada(Long qtdeParcelada) {
        this.qtdeParcelada = qtdeParcelada;
    }

    @Generated
    public void setSituacaoNina(Long situacaoNina) {
        this.situacaoNina = situacaoNina;
    }

    @Generated
    public void setExisteCadastro(Long existeCadastro) {
        this.existeCadastro = existeCadastro;
    }

    @Generated
    public void setSituacaoAntiga(Long situacaoAntiga) {
        this.situacaoAntiga = situacaoAntiga;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setValorPago(Long valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setValorCalculado(Long valorCalculado) {
        this.valorCalculado = valorCalculado;
    }

    @Generated
    public void setAnoReferencia(Long anoReferencia) {
        this.anoReferencia = anoReferencia;
    }

    @Generated
    public void setMesReferencia(Long mesReferencia) {
        this.mesReferencia = mesReferencia;
    }

    @Generated
    public void setIdDebitoParcela(Long idDebitoParcela) {
        this.idDebitoParcela = idDebitoParcela;
    }

    @Generated
    public void setProcessoJudicial(String processoJudicial) {
        this.processoJudicial = processoJudicial;
    }

    @Generated
    public void setDataAjuizamento(LocalDate dataAjuizamento) {
        this.dataAjuizamento = dataAjuizamento;
    }

    @Generated
    public void setIdProtesto(Long idProtesto) {
        this.idProtesto = idProtesto;
    }

    @Generated
    public void setTributos(List<DebitoParcelaTributo> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setObservacoes(List<DebitoParcelaObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoParcela)) {
            return false;
        }
        DebitoParcela other = (DebitoParcela)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoParcelaId this$id = this.getId();
        DebitoParcelaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoParcela;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoParcelaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoParcela(id=" + this.getId() + ")";
    }
}

