/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.CarneId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCARNE")
public class Carne
implements EloEntity<CarneId>,
Serializable {
    @EmbeddedId
    private CarneId id;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long numero;
    private LocalDate data;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean retirado = Boolean.FALSE;
    private LocalDate dataRetirada;
    private String situacaoNaoRetirado;
    private LocalDate dataSituacao;
    @Length(max=15)
    private @Length(max=15) String usuario;
    @Length(max=60)
    private @Length(max=60) String codigoBarras;
    @Length(max=15)
    private @Length(max=15) String usuarioRetirada;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean impresso = Boolean.FALSE;
    @Length(max=15)
    private @Length(max=15) String usuarioEmissao;
    @OneToMany(mappedBy="carne", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="bloqueto")
    List<CarneBoleto> boletos = new ArrayList();

    @Generated
    public Carne() {
    }

    @Generated
    public CarneId getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Boolean getRetirado() {
        return this.retirado;
    }

    @Generated
    public LocalDate getDataRetirada() {
        return this.dataRetirada;
    }

    @Generated
    public String getSituacaoNaoRetirado() {
        return this.situacaoNaoRetirado;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getUsuarioRetirada() {
        return this.usuarioRetirada;
    }

    @Generated
    public Boolean getImpresso() {
        return this.impresso;
    }

    @Generated
    public String getUsuarioEmissao() {
        return this.usuarioEmissao;
    }

    @Generated
    public List<CarneBoleto> getBoletos() {
        return this.boletos;
    }

    @Generated
    public void setId(CarneId id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setRetirado(Boolean retirado) {
        this.retirado = retirado;
    }

    @Generated
    public void setDataRetirada(LocalDate dataRetirada) {
        this.dataRetirada = dataRetirada;
    }

    @Generated
    public void setSituacaoNaoRetirado(String situacaoNaoRetirado) {
        this.situacaoNaoRetirado = situacaoNaoRetirado;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setUsuarioRetirada(String usuarioRetirada) {
        this.usuarioRetirada = usuarioRetirada;
    }

    @Generated
    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    @Generated
    public void setUsuarioEmissao(String usuarioEmissao) {
        this.usuarioEmissao = usuarioEmissao;
    }

    @Generated
    public void setBoletos(List<CarneBoleto> boletos) {
        this.boletos = boletos;
    }

    @Generated
    public String toString() {
        return "Carne(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", numero=" + this.getNumero() + ", data=" + this.getData() + ", retirado=" + this.getRetirado() + ", dataRetirada=" + this.getDataRetirada() + ", situacaoNaoRetirado=" + this.getSituacaoNaoRetirado() + ", dataSituacao=" + this.getDataSituacao() + ", usuario=" + this.getUsuario() + ", codigoBarras=" + this.getCodigoBarras() + ", usuarioRetirada=" + this.getUsuarioRetirada() + ", impresso=" + this.getImpresso() + ", usuarioEmissao=" + this.getUsuarioEmissao() + ", boletos=" + this.getBoletos() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Carne)) {
            return false;
        }
        Carne other = (Carne)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CarneId this$id = this.getId();
        CarneId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Carne;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CarneId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

