/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.tributos.config.DBUnitDataConfig;
import com.github.springtestdbunit.bean.DatabaseConfigBean;
import com.github.springtestdbunit.bean.DatabaseDataSourceConnectionFactoryBean;
import com.github.springtestdbunit.dataset.FlatXmlDataSetLoader;
import java.util.Collections;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.boot.CommandLineRunner;

public class DatabaseLoader
implements CommandLineRunner {
    private final DataSource dataSource;
    private final DatabaseConfigBean databaseConfigBean;

    public DatabaseLoader(DataSource dataSource, DatabaseConfigBean databaseConfigBean) {
        this.dataSource = dataSource;
        this.databaseConfigBean = databaseConfigBean;
    }

    public void run(String ... args) throws Exception {
        String[] dbUnit = (String[])Stream.of(this.getDadosDBUnit()).flatMap(Stream::of).toArray(String[]::new);
        this.loadDBUnitDatasets(DatabaseOperation.INSERT, dbUnit);
    }

    private String[] getDadosDBUnit() {
        return DBUnitDataConfig.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBUnitDatasets(DatabaseOperation databaseOperation, String ... datasets) throws Exception {
        IDatabaseConnection connection = DatabaseDataSourceConnectionFactoryBean.newConnection((DataSource)this.dataSource);
        try {
            this.databaseConfigBean.setQualifiedTableNames(Boolean.valueOf(false));
            this.databaseConfigBean.apply(connection.getConfig());
            FlatXmlDataSetLoader dataSetLoader = new FlatXmlDataSetLoader();
            for (String datasetName : datasets) {
                IDataSet dataSet = dataSetLoader.loadDataSet(this.getClass(), datasetName);
                databaseOperation.execute(connection, dataSet);
            }
        }
        finally {
            if (Collections.singletonList(connection).get(0) != null) {
                connection.close();
            }
        }
    }
}

