SELECT
   debitoparcela.parcela,
   debitoparcela.datavencimento,
   situacaoparcela.descricao AS situacao,
   SUM(debitoParcelareceita.valor) AS valor,
   SUM(debitoParcelareceita.valorJuros) AS valorJuros,
   SUM(debitoParcelareceita.valorMulta) AS valorMulta,
   SUM(debitoParcelareceita.valorCorrecao) AS valorCorrecao,
   SUM(debitoParcelareceita.valorDesconto) AS valordesconto
FROM TribParcelamentoDebito parcelamentoDebito
LEFT OUTER JOIN TribDebito debito
   ON parcelamentoDebito.idDebito = debito.idDebito
left outer join tribdebitoparcela debitoparcela
   ON debito.entidade = debitoParcela.entidade
   AND debito.exercicio = debitoParcela.exercicio
   AND debito.tipoCadastro = debitoParcela.tipoCadastro
   AND debito.cadastroGeral = debitoParcela.cadastroGeral
   AND debito.guiaRecolhimento = debitoParcela.guiaRecolhimento
   AND debito.subDivida = debitoParcela.subDivida
left outer join tribsituacaoparcela situacaoparcela
   on debitoparcela.situacaodebito = situacaoparcela.situacaoparcela
LEFT OUTER JOIN TribDebitoParcelaReceita debitoParcelareceita
   ON debitoParcela.entidade = debitoParcelareceita.entidade
   AND debitoParcela.exercicio = debitoParcelareceita.exercicio
   AND debitoParcela.tipoCadastro = debitoParcelareceita.tipoCadastro
   AND debitoParcela.cadastroGeral = debitoParcelareceita.cadastroGeral
   AND debitoParcela.guiaRecolhimento = debitoParcelareceita.guiaRecolhimento
   AND debitoParcela.subDivida = debitoParcelareceita.subDivida
   AND debitoParcela.parcela = debitoParcelaReceita.parcela
WHERE parcelamentoDebito.idParcelamento = ?
GROUP BY debitoparcela.parcela,
   debitoparcela.datavencimento,
   situacaoparcela.descricao
ORDER BY debitoparcela.parcela