
SELECT debitoOrigem.idDebito,
     debito.entidade,
     debito.exercicio,
     debito.tipoCadastro,
     debito.cadastroGeral,
     debito.guiaRecolhimento,
     debito.subDivida,
     debito.dataLancamento,
     SUM(espelho.valor) valor,
     SUM(espelho.valorJuros) AS valorJuros,
     SUM(espelho.valorMulta) AS valorMulta,
     SUM(espelho.valorCorrecao) AS valorCorrecao,
     SUM(espelho.valorDescontoPrincipal 
          + espelho.valorDescontoJuros 
          + espelho.valorDescontoMulta 
          + espelho.valorDescontoCorrecao
     ) AS valorDesconto,
     SUM(espelho.valorJurosFinan) as valorJurosFinanciamento
FROM TribParcelamentoDebitoOrigem debitoOrigem
LEFT OUTER JOIN TribDebito debito ON
     debitoOrigem.IdDebito = debito.idDebito
LEFT OUTER JOIN TribParcelamentoReceitaEspelho espelho
     ON debitoOrigem.idParcelamento = espelho.idParcelamento 
     AND debitoOrigem.idDebito = espelho.idDebito     
WHERE debitoOrigem.idParcelamento = ?
GROUP BY debitoOrigem.idDebito,
     debito.entidade,
     debito.exercicio,
     debito.tipoCadastro,
     debito.cadastroGeral,
     debito.guiaRecolhimento,
     debito.subDivida,
     debito.dataLancamento
ORDER BY debito.exercicio DESC, debito.guiaRecolhimento, debito.subdivida
      