select ger.tipocadastro,
       ger.cadastrogeral,
       pes.pessoa,
       pes.nome,
       pes.cnpj_cpf as cpfCnpj,
       logr.descricao as rua,
       ger.numero,
       ger.complemento,
       ger.cep,
       cid.descricao as cidade,
       uni.descricao as estado,
       ger.idCadastroGeralIss,
       coalesce(sit_imob.situacaoimobiliario, sit_mob.situacaomobiliario) as situacao,
       coalesce(ts_imob.descricao, ts_mob.descricao) as descSituacao,
       cad_mob.numeroAlvara,
       cad_mob.exercicioAlvara,
       cad_mob.atividadePrincipal,
       cad_mob.observacaoAlvara,
       cad_mob.dataAbertura,
       cad_mob.dataEncerramento,
       cad_mob.dataValidadeAlvara,
       cad_mob.dataUltimaFiscalizacao,
       case 
        when (select count(*) from tribrepresentantelegal a
              where a.pessoa = pes.pessoa
              and a.tipocadastro = ger.tipocadastro
              and a.cadastrogeral = ger.cadastrogeral) = 1 then 'S' else 'N'
       end as representanteLegal
from pessoa pes
inner join (select p.pessoa, p.cnpj_cpf, a.tipocadastro, a.cadastrogeral
            from pessoa p
            inner join tribrepresentantelegal a on p.pessoa = a.pessoa
            left join tribtiporepresentante b on a.tiporepresentante = b.tiporepresentante and b.administrador = 'S'
            union
            select p.pessoa, p.cnpj_cpf, a.tipocadastro, a.cadastrogeral
            from pessoa p
            inner join tribproprietario a on p.pessoa = a.pessoa) cad on pes.pessoa = cad.pessoa 
                                                                     and pes.cnpj_cpf = cad.cnpj_cpf
inner join tribcadastrogeral ger on ger.tipocadastro  = cad.tipocadastro
                                and ger.cadastrogeral = cad.cadastrogeral
left outer join logradouro logr on logr.cidade     = ger.cidade
                               and logr.logradouro = ger.logradouro
left outer join cidade cid on cid.cidade = ger.cidade
left outer join unidadefederacao uni on uni.unidadefederacao = cid.unidadefederacao
                                    and uni.pais = cid.pais
left outer join tribcadastroimobiliario cad_imob on ger.tipocadastro = cad_imob.tipocadastro
                                                and ger.cadastrogeral = cad_imob.cadastrogeral
left outer join (select a.tipocadastro, a.cadastrogeral, max(a.sequencia) as sequencia
                 from tribimobiliariosituacao a where a.atual = 'S'
                 group by a.tipocadastro, a.cadastrogeral) s_imob on cad_imob.tipocadastro = s_imob.tipocadastro
                                                                 and cad_imob.cadastrogeral = s_imob.cadastrogeral
left outer join tribimobiliariosituacao sit_imob on s_imob.tipocadastro = sit_imob.tipocadastro
                                               and s_imob.cadastrogeral = sit_imob.cadastrogeral
                                               and s_imob.sequencia = sit_imob.sequencia
left outer join tribsituacaoimobiliario ts_imob on sit_imob.situacaoimobiliario = ts_imob.situacaoimobiliario                                              
left outer join tribcadastromobiliario cad_mob on ger.tipocadastro = cad_mob.tipocadastro
                                              and ger.cadastrogeral = cad_mob.cadastrogeral
left outer join (select a.tipocadastro, a.cadastrogeral, max(a.sequencia) as sequencia
                 from tribmobiliariosituacao a where a.atual = 'S'
                 group by a.tipocadastro, a.cadastrogeral) s_mob on cad_mob.tipocadastro = s_mob.tipocadastro
                                                                and cad_mob.cadastrogeral = s_mob.cadastrogeral
left outer join tribmobiliariosituacao sit_mob on s_mob.tipocadastro = sit_mob.tipocadastro
                                              and s_mob.cadastrogeral = sit_mob.cadastrogeral
                                              and s_mob.sequencia = sit_mob.sequencia
left outer join tribsituacaomobiliario ts_mob on sit_mob.situacaomobiliario = ts_mob.situacaomobiliario                                              
where pes.cnpj_cpf = ?
and   exists (select 1
              from tribdebito deb
              inner join tribdebitoparcela par on par.entidade         = deb.entidade
                                              and par.exercicio        = deb.exercicio
                                              and par.tipocadastro     = deb.tipocadastro
                                              and par.cadastrogeral    = deb.cadastrogeral
                                              and par.guiarecolhimento = deb.guiarecolhimento
                                              and par.subdivida        = deb.subdivida
              inner join tribsituacaoparcela sit on sit.situacaoparcela = par.situacaodebito
              inner join tribtiposituacaoparcela tip on tip.tiposituacaoparcela = sit.situacaoparcela
              where deb.tipocadastro  = ger.tipocadastro
              and   deb.cadastrogeral = ger.cadastrogeral
              and   deb.constituido   = 'S'
              and   tip.tipo = 'A')