/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public final class DateUtils {
    public static final Integer DAYS_PER_MONTH = 30;
    public static final Double DAYS_PER_MONTH_INCOMP = 30.4375;
    public static final Double DAYS_YEAR_INCOMP = 365.25;

    private DateUtils() {
    }

    public static Long daysBetween(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static Long monthsBetween(LocalDate startDate, LocalDate endDate) {
        return startDate.withDayOfMonth(1).until(endDate.withDayOfMonth(1), ChronoUnit.MONTHS);
    }

    public static Long monthsBetweenDelphi(LocalDate startDate, LocalDate endDate) {
        Long dateDiff = startDate.getDayOfMonth() == endDate.getDayOfMonth() ? -1L : 0L;
        return startDate.until(endDate, ChronoUnit.MONTHS) + dateDiff;
    }

    public static Long yearsBetweenDelphi(LocalDate startDate, LocalDate endDate) {
        return (long)Math.floor((double)(endDate.toEpochDay() - startDate.toEpochDay()) / DAYS_YEAR_INCOMP);
    }
}

