/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.GeraCarneDTO;
import br.com.elotech.tributos.dto.GeraCarnePorFormaPagamentoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.exception.DebitoNotFoundException;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import java.util.Objects;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseCarneServiceRest
implements CarneService {
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final RestTemplate restTemplate;
    private final AiseWSMapper aiseWSMapper;
    private final DebitoRepository debitoRepository;

    public AiseCarneServiceRest(AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, RestTemplate restTemplate, AiseWSMapper aiseWSMapper, DebitoRepository debitoRepository) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.restTemplate = restTemplate;
        this.aiseWSMapper = aiseWSMapper;
        this.debitoRepository = debitoRepository;
    }

    private HttpHeaders getHttpHeaders(LoginRespostaRest loginResposta) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        return headers;
    }

    public CarneDTO geraCarne(DebitoCarneDTO params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        String debitosDelphi = this.aiseWSMapper.toEnvioRest(params);
        HttpEntity entity = new HttpEntity((Object)debitosDelphi, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tcarnes/gerar/", HttpMethod.POST, entity, CarneDTO.class, new Object[0]);
        return (CarneDTO)response.getBody();
    }

    public CarneDTO geraCarnePorFormaPagamento(GeraCarnePorFormaPagamentoDTO params) {
        GeraCarneDTO geraCarneDTO = this.criaRequisicaoGeraCarnePorFormaPagamento(params);
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tcarnes/gerarPorFormaPagamento/", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)geraCarneDTO, (HttpHeaders)headers), CarneDTO.class, new Object[0]);
        return (CarneDTO)response.getBody();
    }

    private GeraCarneDTO criaRequisicaoGeraCarnePorFormaPagamento(GeraCarnePorFormaPagamentoDTO boletoCotaFormaPagamentoDTO) {
        Debito debito = (Debito)this.debitoRepository.findOne((Object)boletoCotaFormaPagamentoDTO.getIdDebito());
        if (Objects.isNull(debito)) {
            throw new DebitoNotFoundException(boletoCotaFormaPagamentoDTO.getIdDebito());
        }
        GeraCarneDTO geraBoletoCotaUnicaDTO = new GeraCarneDTO();
        geraBoletoCotaUnicaDTO.setEntidade(debito.getEntidade());
        geraBoletoCotaUnicaDTO.setExercicio(debito.getExercicio());
        geraBoletoCotaUnicaDTO.setTipoCadastro(debito.getCadastroGeral().getTipoCadastro().getValue());
        geraBoletoCotaUnicaDTO.setCadastroGeral(debito.getCadastroGeral().getCadastroGeral());
        geraBoletoCotaUnicaDTO.setDivida(debito.getDivida().getDivida());
        geraBoletoCotaUnicaDTO.setSubDivida(debito.getSubDivida());
        geraBoletoCotaUnicaDTO.setFormaPagamento(boletoCotaFormaPagamentoDTO.getFormaPagamento());
        return geraBoletoCotaUnicaDTO;
    }
}

