/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.TipoItbi;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.dto.IdItbiDTO;
import br.com.elotech.tributos.dto.ImobiliarioItbiDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.ProprietarioItbiDTO;
import br.com.elotech.tributos.repository.ImobiliarioItbiRepository;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.ItbiService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.TipoItbiService;
import br.com.elotech.tributos.service.exception.ImobiliarioItbiNotFound;
import br.com.elotech.tributos.service.exception.ParametroItbiNaoEncontradoException;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaResponseDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ItbiServiceImpl
implements ItbiService {
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final ImobiliarioItbiRepository imobiliarioItbiRepository;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final PessoaService pessoaService;
    private final TipoItbiService tipoItbiService;
    private static final Integer IN_STATEMENT_MAX_LENGTH = 999;

    public ItbiServiceImpl(EntidadeService entidadeService, ExercicioService exercicioService, ImobiliarioItbiRepository imobiliarioItbiRepository, EntidadeTributacaoService entidadeTributacaoService, PessoaService pessoaService, TipoItbiService tipoItbiService) {
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.imobiliarioItbiRepository = imobiliarioItbiRepository;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.pessoaService = pessoaService;
        this.tipoItbiService = tipoItbiService;
    }

    public ImobiliarioItbi gerarItbi(ImobiliarioItbiDTO dto) {
        Long entidade = this.entidadeService.findEntidadePrincipal().getId();
        Long exercicio = this.exercicioService.getExercicio();
        dto.convertToUpperCase();
        ImobiliarioItbi itbi = ImobiliarioItbi.from((ImobiliarioItbiDTO)dto);
        itbi.setEntidade(entidade);
        itbi.setExercicio(exercicio);
        itbi.setDataLancamento(LocalDate.now());
        itbi.setDataSituacao(LocalDate.now());
        itbi.setDataInclusao(LocalDate.now());
        itbi.setCodigoItbi(this.imobiliarioItbiRepository.findNextCodigoItbiByExercicio(entidade, exercicio));
        itbi.setTipoItbi((TipoItbi)this.tipoItbiService.findOne((Serializable)dto.getTipoItbi()));
        itbi.setParametroItbi(this.parametroItbiPrincipal(entidade, exercicio));
        itbi.setGuiaRecolhimento(itbi.getParametroItbi().getGuiaRecolhimento());
        itbi.setDataVencimento(LocalDate.now().plusDays(itbi.getParametroItbi().getPrazoPagamento()));
        this.carregarListasProprietarios(itbi, dto);
        if (!dto.getSegmentos().isEmpty()) {
            dto.getSegmentos().forEach(arg_0 -> ((ImobiliarioItbi)itbi).addSegmento(arg_0));
        }
        itbi.validar();
        return (ImobiliarioItbi)this.imobiliarioItbiRepository.save((Object)itbi);
    }

    private void carregarListasProprietarios(ImobiliarioItbi itbi, ImobiliarioItbiDTO dto) {
        this.carregarProprietarios(itbi, dto.getCompradores(), TipoProprietarioItbi.COMPRADOR);
        this.carregarProprietarios(itbi, dto.getVendedores(), TipoProprietarioItbi.VENDEDOR);
        this.carregarProprietarios(itbi, dto.getAnuentes(), TipoProprietarioItbi.ANUENTE);
        this.carregarNovosProprietarios(itbi, dto.getNovosProprietarios());
    }

    private void carregarProprietarios(ImobiliarioItbi itbi, List<ProprietarioItbiDTO> proprietariosDto, TipoProprietarioItbi tipo) {
        proprietariosDto.forEach(proprietarioDto -> {
            ProprietarioItbi proprietarioItbi = ProprietarioItbi.from((ProprietarioItbiDTO)proprietarioDto);
            Pessoa pessoa = this.pessoaService.findByCnpjCpf(proprietarioDto.getPessoaDTO().getCnpjCpf());
            proprietarioDto.getPessoaDTO().setActiveFormOrigem("ITBI Online");
            if (Objects.nonNull(pessoa)) {
                this.pessoaService.alterarEnderecoPessoa(proprietarioDto.getPessoaDTO());
                itbi.addProprietario(proprietarioItbi, pessoa, tipo);
            } else {
                itbi.addProprietario(proprietarioItbi, this.carregarPessoa(proprietarioDto.getPessoaDTO()), tipo);
            }
        });
    }

    private Pessoa carregarPessoa(PessoaDTO pessoaDTO) {
        IncluirPessoaRequestDTO requestPessoaDTO = IncluirPessoaRequestDTO.from((PessoaDTO)pessoaDTO);
        IncluirPessoaResponseDTO responsePessoaDTO = this.pessoaService.incluirPessoa(requestPessoaDTO);
        return (Pessoa)this.pessoaService.findOne((Serializable)responsePessoaDTO.getPessoa());
    }

    private void carregarNovosProprietarios(ImobiliarioItbi itbi, List<ProprietarioItbiDTO> novosProprietarios) {
        novosProprietarios.forEach(novoProprietario -> {
            ProprietarioItbi proprietarioItbi = ProprietarioItbi.from((ProprietarioItbiDTO)novoProprietario);
            itbi.addProprietario(proprietarioItbi, this.pessoaService.findByCnpjCpf(novoProprietario.getPessoaDTO().getCnpjCpf()), TipoProprietarioItbi.ATUAL);
        });
    }

    private ParametroItbi parametroItbiPrincipal(Long entidade, Long exercicio) {
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio);
        if (entidadeTributacao != null) {
            return entidadeTributacao.getParametroITBI();
        }
        throw new ParametroItbiNaoEncontradoException();
    }

    public List<IdItbiDTO> verificarPagos(List<IdItbiDTO> listIdItbi) {
        List partitions = Lists.partition(listIdItbi.stream().map(IdItbiDTO::getIdItbi).filter(Objects::nonNull).collect(Collectors.toList()), (int)IN_STATEMENT_MAX_LENGTH);
        return partitions.stream().map(arg_0 -> ((ImobiliarioItbiRepository)this.imobiliarioItbiRepository).findIdItbiPagoById(arg_0)).flatMap(Collection::stream).map(IdItbiDTO::new).collect(Collectors.toList());
    }

    public ImobiliarioItbi findImobiliarioItbiById(Long idSequencia) {
        return (ImobiliarioItbi)this.imobiliarioItbiRepository.findById((Object)idSequencia).orElseThrow(() -> new ImobiliarioItbiNotFound(idSequencia));
    }
}

