/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.ResultadoAcrescimoDTO;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaComum;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaEspecialService;
import br.com.elotech.tributos.util.CalculoValoresResources;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CalculoAcrescimoService {
    private final EntidadeCorrecaoService entidadeCorrecaoService;
    private final CalculoMultaEspecialService calculoMultaEspecialService;
    private final DiaUtilService diaUtilService;
    private static final BigDecimal DIVISOR_100 = BigDecimal.valueOf(100L);

    public CalculoAcrescimoService(EntidadeCorrecaoService entidadeCorrecaoService, CalculoMultaEspecialService calculoMultaEspecialService, DiaUtilService diaUtilService) {
        this.entidadeCorrecaoService = entidadeCorrecaoService;
        this.calculoMultaEspecialService = calculoMultaEspecialService;
        this.diaUtilService = diaUtilService;
    }

    public BigDecimal calcularJuros(EntidadeCorrecao entidadeCorrecao, AcrescimoDTO params) {
        if (!entidadeCorrecao.getEntidadeCorrecaoIndiceJuros().incideNaSituacao(params.getSituacaoLegal()).booleanValue() || Objects.nonNull(params.getTributo()) && !params.getTributo().getIncideJuros().booleanValue()) {
            return BigDecimal.ZERO;
        }
        if (!params.getDataReferencia().isAfter(params.getDataVencimento())) {
            return BigDecimal.ZERO;
        }
        BigDecimal aliquotaVariavel = new BigDecimal(entidadeCorrecao.getMesJuros().getCalculoJuros().calculaAliquota(params.getDataVencimento(), params.getDataReferencia()));
        return params.getValor().multiply(entidadeCorrecao.getJuroMora()).multiply(aliquotaVariavel).divide(DIVISOR_100, (int)CalculoValoresResources.QUANTIDADE_CASAS_DECIMAIS, 4);
    }

    public BigDecimal calcularMulta(EntidadeCorrecao entidadeCorrecao, AcrescimoDTO params) {
        BigDecimal percentualMultaComum;
        if (!entidadeCorrecao.getEntidadeCorrecaoIndiceMulta().incideNaSituacao(params.getSituacaoLegal()).booleanValue() || Objects.nonNull(params.getTributo()) && !params.getTributo().getIncideMulta().booleanValue()) {
            return BigDecimal.ZERO;
        }
        Long diasAtraso = this.diaUtilService.countDiasAtraso(params.getDataVencimento(), params.getDataReferencia(), entidadeCorrecao.getMultaDias());
        if (diasAtraso <= 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal percentualMulta = percentualMultaComum = CalculoMultaComum.calculaValorMulta((List)entidadeCorrecao.getCorrecaoMulta(), (Long)diasAtraso, (Boolean)params.getSituacaoLegal().isDividaAtivaOrJuizo(), (Boolean)params.getParcelado());
        if (!entidadeCorrecao.getSobreporMulta().booleanValue()) {
            BigDecimal percentualMultaEspecial = this.calculoMultaEspecialService.calculaValorMultaEspecial(entidadeCorrecao.getCorrecaoMultaEspecial(), params.getDataVencimento(), params.getDataReferencia(), entidadeCorrecao.getMultaDias());
            percentualMulta = percentualMultaComum.add(percentualMultaEspecial);
        }
        return params.getValor().multiply(percentualMulta).divide(DIVISOR_100, (int)CalculoValoresResources.QUANTIDADE_CASAS_DECIMAIS, 4);
    }

    public ResultadoAcrescimoDTO calculaAcrescimos(AcrescimoDTO params, EntidadeCorrecao entidadeCorrecao) {
        return ResultadoAcrescimoDTO.builder().principal(params.getValor()).juros(this.calcularJuros(entidadeCorrecao, params)).multa(this.calcularMulta(entidadeCorrecao, params)).build();
    }

    public ResultadoAcrescimoDTO calculaAcrescimos(AcrescimoDTO params) {
        if (Objects.isNull(params.getEntidade()) || Objects.isNull(params.getExercicio())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel realizar o c\u00e1lculo pois n\u00e3o foram informados os dados da entidade e do exerc\u00edcio.");
        }
        EntidadeCorrecao entidadeCorrecao = this.entidadeCorrecaoService.getEntidadeCorrecao(params.getEntidade(), params.getExercicio(), Optional.ofNullable(params.getDivida()).map(DividaDTO::getDivida));
        return this.calculaAcrescimos(params, entidadeCorrecao);
    }
}

