/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.report.loader.ContratoParcelamentoParamLoader;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParcelamentoService
extends CrudService<Parcelamento, Long> {
    private final ParcelamentoRepository parcelamentoRepository;
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final ContratoParcelamentoParamLoader contratoParcelamentoParamLoader;
    private static final Integer RELATORIO_SITUACAO_CONTRATO = 1054;

    @Autowired
    public ParcelamentoService(ParcelamentoRepository parcelamentoRepository, ParamParcelamentoRepository paramParcelamentoRepository, ContratoParcelamentoParamLoader contratoParcelamentoParamLoader) {
        this.parcelamentoRepository = parcelamentoRepository;
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.contratoParcelamentoParamLoader = contratoParcelamentoParamLoader;
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoOrigem(idParcelamento);
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoNovo(idParcelamento);
    }

    public List<ParcelaParcelamentoDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoParcelas(idParcelamento);
    }

    public ImprimirRelatorioDTO getImprimirContratoDTO(Long idParcelamento) {
        Long idParamParcelamento = this.findIdParamParcelamento(idParcelamento);
        ParamParcelamento paramParcelamento = this.findParamParcelamento(idParamParcelamento);
        Relatorio relatorioContrato = Optional.ofNullable(paramParcelamento.getRelatorio()).orElseThrow(() -> new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Relat\u00f3rio de impress\u00e3o do contrato n\u00e3o configurado para o par\u00e2metro de %s %d.", paramParcelamento.getTipo().getDescricao(), paramParcelamento.getId())));
        ImprimirRelatorioDTO dto = this.createImprimirContratoDTO(idParcelamento, relatorioContrato, paramParcelamento.getSequenciaEmissaoRelatorio());
        return dto;
    }

    private ParamParcelamento findParamParcelamento(Long idParamParcelamento) {
        return (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)idParamParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Par\u00e2metro do Parcelamento com id %d", idParamParcelamento)));
    }

    private Long findIdParamParcelamento(Long idParcelamento) {
        return (Long)this.parcelamentoRepository.findIdParametroParcelamentoByIdParcelamento(idParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Parcelamento com id %d", idParcelamento)));
    }

    private ImprimirRelatorioDTO createImprimirContratoDTO(Long idParcelamento, Relatorio relatorioContrato, Long sequenciaImpressao) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setModulo(relatorioContrato.getId().getModulo());
        dto.setRelatorio(relatorioContrato.getId().getRelatorio());
        dto.setTipoRelatorioFromEnum(relatorioContrato.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("Rel_IdParcelamento=%d\r\nIdParcelamento=%d\r\n", idParcelamento, idParcelamento));
        dto.setSequenciaTipoEmissao(sequenciaImpressao);
        dto.setSubReports(this.createSubReportImprimirContratoDTO(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReportImprimirContratoDTO(String filtroPadrao) {
        SubReportDTO subReport = new SubReportDTO();
        subReport.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Detalhe", filtroPadrao), new SubReportItemDTO("Comprador", filtroPadrao), new SubReportItemDTO("Vendedor", filtroPadrao), new SubReportItemDTO("CadastroContribuinte", filtroPadrao)}));
        return subReport;
    }

    public ImprimirRelatorioDTO getImprimirSituacaoContratoDTO(Long idParcelamento) {
        this.findIdParamParcelamento(idParcelamento);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(RELATORIO_SITUACAO_CONTRATO);
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("IdParcelamento=%d\r\n", idParcelamento));
        return dto;
    }
}

