/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.report.loader.CabecalhoParamLoader;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@Service
public class ImobiliarioCompletoRelatorioService {
    private static final String CADASTROIMOBILIARIOCOMPLETO = "sql/cadastroimobiliariocompleto.sql";
    private static final String PROPRIETARIOS = "sql/proprietarios.sql";
    private static final String TESTADA = "sql/testada.sql";
    private static final String CAUCAO = "sql/caucao.sql";
    private static final String SEGMENTO = "sql/segmento.sql";
    private static final String TERRENO = "sql/terreno.sql";
    private static final String OBSERVACAOIMOBILIARIO = "sql/observacaoimobiliario.sql";
    private static final String AREAVERDE = "sql/areaverde.sql";
    private static final String GEMINADA = "sql/geminada.sql";
    private static final String ISENCAO = "sql/isencao.sql";
    private static final String SEGMENTODEMOLICAO = "sql/segmentodemolicao.sql";
    public static final String DATASET_CABECALHO = "Cabecalho";
    public static final String DATASET_CADASTRO_IMOB_COMPLETO = "CadastroImobiliarioCompleto";
    public static final String DATASET_PROPRIETARIOS = "Proprietarios";
    public static final String DATASET_TESTADA = "Testada";
    public static final String DATASET_CAUCAO = "Caucao";
    public static final String DATASET_SEGMENTO = "Segmento";
    public static final String DATASET_TERRENO = "terreno";
    public static final String DATASET_OBSERVACAO_IMOBILIARIO = "ObservacaoImobiliario";
    public static final String DATASET_AREAVERDE = "AreaVerde";
    public static final String DATASET_GEMINADA = "Geminada";
    public static final String DATASET_ISENCAO = "ISENCAO";
    public static final String DATASET_SEGMENTO_DEMOLICAO = "SegmentoDemolicao";
    private final DataSource dataSource;
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;
    private final CabecalhoParamLoader cabecalhoParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public ImobiliarioCompletoRelatorioService(DataSource dataSource, EntidadeRepository entidadeRepository, ExercicioService exercicioService, CabecalhoParamLoader cabecalhoParamLoader, ReportFileResolverFactory reportFileResolverFactory) {
        this.dataSource = dataSource;
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
        this.cabecalhoParamLoader = cabecalhoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public byte[] createImobiliarioCompletoPdfReport(CadastroGeralParams params) {
        Map paramCadastroImobCompleto = params.toMapParams();
        paramCadastroImobCompleto.put("entidade", this.entidadeRepository.findByEntidadeprincipal().getId());
        paramCadastroImobCompleto.put("exercicio", this.exercicioService.getExercicio());
        ReportDatasource reportDatasource = ReportDatasource.builder().add(DATASET_CABECALHO, (ReportDataLoader)this.cabecalhoParamLoader.datasetLoader(this.dataSource)).add(DATASET_CADASTRO_IMOB_COMPLETO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)CADASTROIMOBILIARIOCOMPLETO), (Map)paramCadastroImobCompleto, (DataSource)this.dataSource)).add(DATASET_PROPRIETARIOS, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)PROPRIETARIOS), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_TESTADA, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)TESTADA), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_CAUCAO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)CAUCAO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_SEGMENTO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)SEGMENTO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_TERRENO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)TERRENO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_OBSERVACAO_IMOBILIARIO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)OBSERVACAOIMOBILIARIO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_AREAVERDE, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)AREAVERDE), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_GEMINADA, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)GEMINADA), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_ISENCAO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)ISENCAO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_SEGMENTO_DEMOLICAO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)SEGMENTODEMOLICAO), (Map)params.toMapParams(), (DataSource)this.dataSource)).params((ParamLoader)this.cabecalhoParamLoader).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioTributos.CADASTRO_IMOBILIARIO_COMPLETO.getDefaultRpt())).setReportDatasource(reportDatasource).build().exportToPdf();
    }
}

