/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.DebitoCotaUnicaDTO;
import br.com.elotech.tributos.dto.DebitoParcelaReceitaCotaUnicaDTO;
import br.com.elotech.tributos.repository.DebitoCotaUnicaRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoCotaUnicaService {
    private final DebitoCotaUnicaRepository debitoCotaUnicaRepository;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;

    public DebitoCotaUnicaService(DebitoCotaUnicaRepository debitoCotaUnicaRepository, ExercicioService exercicioService, EntidadeService entidadeService) {
        this.debitoCotaUnicaRepository = debitoCotaUnicaRepository;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
    }

    public List<DebitoCotaUnicaDTO> findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(Long tipoCadastro, Long cadastroGeral) {
        Long exercicio = this.exercicioService.getExercicio();
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        List debitosParcelaReceitaCotaUnicaDTO = this.debitoCotaUnicaRepository.findAllDebitoParcelaReceitaDisponivelWeb(entidade.getId(), exercicio, tipoCadastro, cadastroGeral, LocalDate.now());
        Map<Long, Map<Long, List<DebitoParcelaReceitaCotaUnicaDTO>>> agregateDebitos = debitosParcelaReceitaCotaUnicaDTO.stream().map(debito -> {
            debito.applyDesconto();
            return debito;
        }).collect(Collectors.groupingBy(DebitoParcelaReceitaCotaUnicaDTO::getIdDebito, Collectors.groupingBy(DebitoParcelaReceitaCotaUnicaDTO::getFormaPagamento)));
        ArrayList debitos = new ArrayList();
        Comparator<DebitoCotaUnicaDTO> ordemEmissaoComparator = Comparator.comparing(DebitoCotaUnicaDTO::getOrdemEmissao, Comparator.nullsFirst(Comparator.naturalOrder()));
        agregateDebitos.forEach((idDebito, values) -> debitos.addAll(this.convert(values)));
        return debitos.stream().sorted(Comparator.comparingLong(DebitoCotaUnicaDTO::getSubDivida).thenComparing(ordemEmissaoComparator).thenComparing(Comparator.comparingLong(DebitoCotaUnicaDTO::getFormaPagamento))).collect(Collectors.toList());
    }

    private List<DebitoCotaUnicaDTO> convert(Map<Long, List<DebitoParcelaReceitaCotaUnicaDTO>> agrupados) {
        ArrayList<DebitoCotaUnicaDTO> resultadoAgrupado = new ArrayList<DebitoCotaUnicaDTO>();
        agrupados.forEach((formaPagamento, values) -> {
            DebitoParcelaReceitaCotaUnicaDTO debitoParcelaReceita = values.stream().findFirst().orElse(null);
            if (Objects.nonNull(debitoParcelaReceita)) {
                DebitoCotaUnicaDTO debitoCotaUnicaDTO = new DebitoCotaUnicaDTO();
                debitoCotaUnicaDTO.setIdDebito(debitoParcelaReceita.getIdDebito());
                debitoCotaUnicaDTO.setExercicio(debitoParcelaReceita.getExercicio());
                debitoCotaUnicaDTO.setTipoCadastro(debitoParcelaReceita.getTipoCadastro());
                debitoCotaUnicaDTO.setCadastroGeral(debitoParcelaReceita.getCadastroGeral());
                debitoCotaUnicaDTO.setDivida(debitoParcelaReceita.getGuiaRecolhimento());
                debitoCotaUnicaDTO.setSubDivida(debitoParcelaReceita.getSubdivida());
                debitoCotaUnicaDTO.setDescricaoVisualizacao(debitoParcelaReceita.getDescricaoGuia());
                debitoCotaUnicaDTO.setFormaPagamento(debitoParcelaReceita.getFormaPagamento());
                if (TipoFormaPagamento.COTA_UNICA.getValue().equals(debitoParcelaReceita.getTipoFormaPagamento())) {
                    debitoCotaUnicaDTO.setVencimento(debitoParcelaReceita.getVencimento());
                }
                debitoCotaUnicaDTO.setDescricaoFormaPagamento(debitoParcelaReceita.getDescricaoFormaPagamento());
                BigDecimal valorTotal = this.getValorTotal(values);
                BigDecimal valorTotalComDesconto = this.getValorTotalComDesconto(values);
                BigDecimal percentualDesconto = this.getPercentualDesconto(values);
                debitoCotaUnicaDTO.setValor(valorTotalComDesconto);
                debitoCotaUnicaDTO.setValorOriginal(valorTotal);
                debitoCotaUnicaDTO.setPercentualDesconto(percentualDesconto);
                debitoCotaUnicaDTO.setOrdemEmissao(debitoParcelaReceita.getOrdemEmissao());
                resultadoAgrupado.add(debitoCotaUnicaDTO);
            }
        });
        return resultadoAgrupado;
    }

    private BigDecimal getValorTotal(List<DebitoParcelaReceitaCotaUnicaDTO> listDebitoParcelaReceita) {
        Optional<BigDecimal> valorOriginal = listDebitoParcelaReceita.stream().map(DebitoParcelaReceitaCotaUnicaDTO::getValorTotalSemDesconto).reduce((valor1, valor2) -> valor1.add((BigDecimal)valor2));
        if (valorOriginal.isPresent()) {
            return valorOriginal.get();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getValorTotalComDesconto(List<DebitoParcelaReceitaCotaUnicaDTO> listDebitoParcelaReceita) {
        Optional<BigDecimal> valorComDesconto = listDebitoParcelaReceita.stream().map(DebitoParcelaReceitaCotaUnicaDTO::getValorTotal).reduce((valor1, valor2) -> valor1.add((BigDecimal)valor2));
        if (valorComDesconto.isPresent()) {
            return valorComDesconto.get();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getPercentualDesconto(List<DebitoParcelaReceitaCotaUnicaDTO> listDebitoParcelaReceita) {
        List listaDescontos = listDebitoParcelaReceita.stream().map(DebitoParcelaReceitaCotaUnicaDTO::getDesconto).filter(f -> f.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!listaDescontos.isEmpty()) {
            return (BigDecimal)listaDescontos.get(0);
        }
        return BigDecimal.ZERO;
    }
}

