/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CategoriaMobiliario;
import br.com.elotech.tributos.domain.ClassificacaoMobiliario;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.PessoaMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscalPeriodo;
import br.com.elotech.tributos.dto.CadastroMobiliarioCnaeDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoDTO;
import br.com.elotech.tributos.exception.CadastroMobiliarioNaoEncontradoException;
import br.com.elotech.tributos.repository.CategoriaMobiliarioRepository;
import br.com.elotech.tributos.repository.ClassificacaoMobiliarioRepository;
import br.com.elotech.tributos.repository.CnaeRepository;
import br.com.elotech.tributos.repository.PessoaMobiliarioRepository;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.repository.RegimeFiscalRepository;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepository;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioCnaeRepository;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class CadastroMobiliarioService
extends CrudService<CadastroMobiliario, Long> {
    private final CadastroMobiliarioRepository cadastroMobiliarioRepository;
    private final PessoaRepository pessoaRepository;
    private final PessoaMobiliarioRepository pessoaMobiliarioRepository;
    private final CategoriaMobiliarioRepository categoriaMobiliarioRepository;
    private final ClassificacaoMobiliarioRepository classificacaoMobiliarioRepository;
    private final CnaeRepository cnaeRepository;
    private final RegimeFiscalRepository regimeFiscalRepository;
    private final MobiliarioCnaeRepository mobiliarioCnaeRepository;

    public CadastroMobiliarioService(CadastroMobiliarioRepository cadastroMobiliarioRepository, PessoaRepository pessoaRepository, PessoaMobiliarioRepository pessoaMobiliarioRepository, CategoriaMobiliarioRepository categoriaMobiliarioRepository, ClassificacaoMobiliarioRepository classificacaoMobiliarioRepoository, CnaeRepository cnaeRepository, RegimeFiscalRepository regimeFiscalRepository, MobiliarioCnaeRepository mobiliarioCnaeRepository) {
        this.cadastroMobiliarioRepository = cadastroMobiliarioRepository;
        this.pessoaRepository = pessoaRepository;
        this.pessoaMobiliarioRepository = pessoaMobiliarioRepository;
        this.categoriaMobiliarioRepository = categoriaMobiliarioRepository;
        this.classificacaoMobiliarioRepository = classificacaoMobiliarioRepoository;
        this.cnaeRepository = cnaeRepository;
        this.regimeFiscalRepository = regimeFiscalRepository;
        this.mobiliarioCnaeRepository = mobiliarioCnaeRepository;
    }

    public CadastroMobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroMobiliarioRepository.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public CadastroMobiliario alteracaoCadastral(CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        CadastroMobiliario cadastroMobiliario = this.buscarCadastroMobiliario(cadastroMobiliarioDTO);
        Optional.ofNullable(cadastroMobiliarioDTO.getPessoaEmpresa()).ifPresent(pessoaEmpresa -> cadastroMobiliario.setPessoaEmpresa((Pessoa)this.pessoaRepository.findOne(pessoaEmpresa)));
        Optional.ofNullable(cadastroMobiliarioDTO.getPessoaMobiliario()).ifPresent(pessoaMobiliario -> cadastroMobiliario.setPessoaMobiliario((PessoaMobiliario)this.pessoaMobiliarioRepository.findOne(pessoaMobiliario)));
        Optional.ofNullable(cadastroMobiliarioDTO.getCategoriaMobiliario()).ifPresent(categoriaMobiliario -> cadastroMobiliario.setCategoriaMobiliario((CategoriaMobiliario)this.categoriaMobiliarioRepository.findOne(categoriaMobiliario)));
        Optional.ofNullable(cadastroMobiliarioDTO.getClassificacaoMobiliario()).ifPresent(classificacaoMobiliario -> cadastroMobiliario.setClassificacaoMobiliario((ClassificacaoMobiliario)this.classificacaoMobiliarioRepository.findOne(classificacaoMobiliario)));
        if (Objects.nonNull(cadastroMobiliarioDTO.getCnaes()) && !cadastroMobiliarioDTO.getCnaes().isEmpty()) {
            cadastroMobiliario.getCadastroMobiliarioCnaes().clear();
            this.mobiliarioCnaeRepository.flush();
            cadastroMobiliario.getCadastroMobiliarioCnaes().addAll(cadastroMobiliarioDTO.getCnaes().stream().map(arg_0 -> this.atualizarCnaes(arg_0)).collect(Collectors.toList()));
        }
        if (Objects.nonNull(cadastroMobiliarioDTO.getRegimesFiscais()) && !cadastroMobiliarioDTO.getRegimesFiscais().isEmpty()) {
            cadastroMobiliario.getRegimeFiscalPeriodo().clear();
            for (RegimeFiscalPeriodoDTO dto : cadastroMobiliarioDTO.getRegimesFiscais()) {
                cadastroMobiliario.getRegimeFiscalPeriodo().add(this.atualizarRegimeFiscal(cadastroMobiliario, dto));
            }
        }
        cadastroMobiliario.set(cadastroMobiliarioDTO);
        return (CadastroMobiliario)this.cadastroMobiliarioRepository.save((Object)cadastroMobiliario);
    }

    private CadastroMobiliario buscarCadastroMobiliario(CadastroMobiliarioDTO dto) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioRepository.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)dto.getTipoCadastro()), dto.getCadastroGeral());
        if (Objects.isNull(cadastroMobiliario)) {
            throw new CadastroMobiliarioNaoEncontradoException(HttpStatus.BAD_REQUEST, String.format("Cadastro %d n\u00e3o encontrado", dto.getCadastroGeral()));
        }
        return cadastroMobiliario;
    }

    private CadastroMobiliarioCnae atualizarCnaes(CadastroMobiliarioCnaeDTO dto) {
        CadastroMobiliarioCnae cnae = CadastroMobiliarioCnae.set((CadastroMobiliarioCnaeDTO)dto);
        cnae.setCnae((Cnae)this.cnaeRepository.findOne((Object)dto.getCnae()));
        return cnae;
    }

    private RegimeFiscalPeriodo atualizarRegimeFiscal(CadastroMobiliario cadastro, RegimeFiscalPeriodoDTO dto) {
        RegimeFiscalPeriodo regime = RegimeFiscalPeriodo.set((RegimeFiscalPeriodoDTO)dto);
        regime.setRegimeFiscal((RegimeFiscal)this.regimeFiscalRepository.findOne((Object)dto.getRegimeFiscal()));
        regime.setCadastroGeralISS(cadastro.getCadastroGeralISS());
        return regime;
    }
}

