/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.EntidadeTributacaoRepository;
import br.com.elotech.tributos.service.ExercicioService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidade-tributacao"})
public class EntidadeTributacaoResource
extends CrudResource<EntidadeTributacao, Long> {
    private final EntidadeRepository entidadeRepository;
    private final EntidadeTributacaoRepository entidadeTributacaoRepository;
    private final ExercicioService exercicioService;

    public EntidadeTributacaoResource(EntidadeRepository entidadeRepository, EntidadeTributacaoRepository entidadeTributacaoRepository, ExercicioService exercicioService) {
        this.entidadeRepository = entidadeRepository;
        this.entidadeTributacaoRepository = entidadeTributacaoRepository;
        this.exercicioService = exercicioService;
    }

    @GetMapping(value={"/entidade"})
    public ResponseEntity<EntidadeTributacao> findByEntidade(@RequestHeader(value="entidade") Long entidade) {
        Entidade entidadeEntity = this.entidadeRepository.findByEntidadeprincipal();
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoRepository.findByEntidadeIdAndExercicio(entidadeEntity.getId(), this.exercicioService.getExercicio());
        return ResponseEntity.ok((Object)entidadeTributacao);
    }
}

