/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.projections.DocumentoFinalidadeProjection;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentofinalidade"})
public class DocumentoFinalidadeResource {
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;

    public DocumentoFinalidadeResource(DocumentoFinalidadeService documentoFinalidadeService, EntidadeRepository entidadeRepository, ExercicioService exercicioService) {
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
    }

    @GetMapping(params={"tipoCertidao"})
    public ResponseEntity<List<DocumentoFinalidadeProjection>> getFinalidade(String tipoCertidao) {
        Entidade entidade = this.entidadeRepository.findByEntidadeprincipal();
        return ResponseEntity.ok().body((Object)this.documentoFinalidadeService.getListDTO(entidade.getId(), this.exercicioService.getExercicio(), TipoDocumentoEnum.fromString((String)tipoCertidao).getCodigo()));
    }

    @GetMapping(value={"/finalidades/{exercicio}"})
    public ResponseEntity<List<DocumentoFinalidadeProjection>> getFinalidade(@PathVariable(value="exercicio") Long exercicio, @RequestHeader(value="entidade") Long entidade) {
        return ResponseEntity.ok().body((Object)this.documentoFinalidadeService.getListDTO(exercicio, entidade));
    }
}

