/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoParcelaReceitaCotaUnicaDTO;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoCotaUnicaRepository {
    private final JdbcTemplate jdbcTemplate;
    private static final String SQL_DISPONIVEL_WEB = "br/com/elotech/tributos/repository/find-debito-disponivel-web.sql";

    public DebitoCotaUnicaRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaReceitaCotaUnicaDTO> findAllDebitoParcelaReceitaDisponivelWeb(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, LocalDate dataVencimento) {
        return this.jdbcTemplate.query(FileUtils.readResourceAsString((String)SQL_DISPONIVEL_WEB), new Object[]{entidade, exercicio, tipoCadastro, cadastroGeral, Date.valueOf(dataVencimento)}, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaReceitaCotaUnicaDTO.class));
    }
}

