/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoHandler;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.codec.digest.DigestUtils;

public class SimulacaoParcelamentoDTO {
    private Integer entidade;
    private Long idParcelamento;
    @NotNull(message="Informe o tipo cadastro")
    private @NotNull(message="Informe o tipo cadastro") Integer tipoCadastro;
    @NotNull(message="Informe o cadastro geral")
    private @NotNull(message="Informe o cadastro geral") Long cadastroGeral;
    @NotNull(message="Informe o tipo do parcelamento")
    private @NotNull(message="Informe o tipo do parcelamento") TipoParcelamento tipo;
    private Integer anoContrato = LocalDate.now().getYear();
    private Long numeroContrato;
    @NotNull(message="Informe o par\u00e2metro do parcelamento")
    private @NotNull(message="Informe o par\u00e2metro do parcelamento") Long idParametroParcelamento;
    private LocalDate dataParcelamento = LocalDate.now();
    @NotNull(message="Informe a data de correcao")
    private @NotNull(message="Informe a data de correcao") LocalDate dataCorrecao;
    @Min(value=1L, message="Informe um n\u00famero de parcelas")
    private @Min(value=1L, message="Informe um n\u00famero de parcelas") Integer numeroParcelas;
    @NotNull(message="Informe o par\u00e2metro de entrada")
    private @NotNull(message="Informe o par\u00e2metro de entrada") Long entrada;
    @NotNull(message="Informe o requerente")
    private @NotNull(message="Informe o requerente") Long requerente;
    private BigDecimal valorEntrada = BigDecimal.ZERO;
    private LocalDate dataEntrada = LocalDate.now();
    private Integer anoProcessoPrazo;
    private Long numeroProcessoPrazo;
    private LocalDate dataProcessoPrazo;
    private LocalDate dataProcessoOrigem;
    private BigDecimal percentualDesconto = BigDecimal.ZERO;
    private Boolean digitouDesconto;
    private Integer anoProcessoDesconto;
    private Long processoDesconto;
    private String observacao;
    private String observacaoUsuario;
    @Size(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres")
    @NotNull(message="Informe o usu\u00e1rio")
    private @Size(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres") @NotNull(message="Informe o usu\u00e1rio") String usuario;
    @NotEmpty(message="Informe ao menos um d\u00e9bito")
    private @NotEmpty(message="Informe ao menos um d\u00e9bito") List<Long> debitos = new ArrayList();
    @Min(value=1L, message="Total selecionado n\u00e3o deve ser zero")
    private @Min(value=1L, message="Total selecionado n\u00e3o deve ser zero") BigDecimal totalSelecionado = BigDecimal.ZERO;
    private BigDecimal valorDemaisParcelas = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal valorDescontos = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private List<ParcelaParcelamentoDTO> parcelas = new ArrayList();
    private String hash;

    public Boolean hasProcessoPrazo() {
        return Optional.ofNullable(this.anoProcessoPrazo).isPresent() && this.anoProcessoPrazo > 0 && Optional.ofNullable(this.dataProcessoPrazo).isPresent() && Optional.ofNullable(this.numeroProcessoPrazo).isPresent() && this.numeroProcessoPrazo > 0L;
    }

    public static SimulacaoParcelamentoDTO from(AiseParcelamentoDTO parcelamentoDTO, SimulacaoParcelamentoDTO paramSimulacao) {
        SimulacaoParcelamentoDTO simulacao = new SimulacaoParcelamentoDTO();
        simulacao.setTipoCadastro(parcelamentoDTO.getTipoCadastro());
        simulacao.setCadastroGeral(parcelamentoDTO.getCadastroGeral());
        simulacao.setTipo(parcelamentoDTO.getTipo());
        simulacao.setAnoContrato(parcelamentoDTO.getAnoContrato());
        simulacao.setIdParametroParcelamento(paramSimulacao.getIdParametroParcelamento());
        simulacao.setDataParcelamento(parcelamentoDTO.getDataParcelamento());
        simulacao.setDataCorrecao(parcelamentoDTO.getDataCorrecao());
        simulacao.setNumeroParcelas(parcelamentoDTO.getNumeroParcela());
        simulacao.setEntrada(paramSimulacao.getEntrada());
        simulacao.setRequerente(parcelamentoDTO.getRequerente());
        simulacao.setValorEntrada(parcelamentoDTO.getValorEntrada());
        simulacao.setDataEntrada(parcelamentoDTO.getDataEntrada());
        simulacao.setAnoProcessoPrazo(paramSimulacao.getAnoProcessoPrazo());
        simulacao.setNumeroProcessoPrazo(paramSimulacao.getNumeroProcessoPrazo());
        simulacao.setDataProcessoPrazo(paramSimulacao.getDataProcessoPrazo());
        simulacao.setDataProcessoOrigem(paramSimulacao.getDataProcessoOrigem());
        simulacao.setPercentualDesconto(paramSimulacao.getPercentualDesconto());
        simulacao.setDigitouDesconto(paramSimulacao.getDigitouDesconto());
        simulacao.setAnoProcessoDesconto(paramSimulacao.getAnoProcessoDesconto());
        simulacao.setProcessoDesconto(paramSimulacao.getProcessoDesconto());
        simulacao.setObservacao(paramSimulacao.getObservacao());
        simulacao.setObservacaoUsuario(paramSimulacao.getObservacaoUsuario());
        simulacao.setUsuario(paramSimulacao.getUsuario());
        simulacao.getDebitos().addAll(paramSimulacao.getDebitos());
        simulacao.setTotalSelecionado(paramSimulacao.getTotalSelecionado());
        simulacao.getParcelas().addAll(ParcelamentoHandler.agruparPorParcela((List)parcelamentoDTO.getDebitos()));
        simulacao.setValorDemaisParcelas(simulacao.getParcelas().size() > 1 ? ((ParcelaParcelamentoDTO)simulacao.getParcelas().get(1)).getValorTotal() : BigDecimal.ZERO);
        simulacao.setValorTotal(simulacao.getParcelas().stream().map(ParcelaParcelamentoDTO::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add));
        parcelamentoDTO.getDebitos().forEach(debito -> {
            simulacao.setValorDescontoPrincipal(simulacao.getValorDescontoPrincipal().add(debito.getValorDescontoPrincipal()));
            simulacao.setValorDescontoMulta(simulacao.getValorDescontoMulta().add(debito.getValorDescontoMulta()));
            simulacao.setValorDescontoJuros(simulacao.getValorDescontoJuros().add(debito.getValorDescontoJuros()));
            simulacao.setValorDescontoCorrecao(simulacao.getValorDescontoCorrecao().add(debito.getValorDescontoCorrecao()));
        });
        simulacao.setValorDescontos(simulacao.getValorDescontoPrincipal().add(simulacao.getValorDescontoMulta()).add(simulacao.getValorDescontoJuros()).add(simulacao.getValorDescontoCorrecao()));
        simulacao.setHash(DigestUtils.md5Hex((String)simulacao.toString()).toUpperCase());
        return simulacao;
    }

    public boolean verificaIntegridadeSimulacao() {
        return Optional.ofNullable(this.hash).isPresent() && this.hash.equalsIgnoreCase(DigestUtils.md5Hex((String)this.toString()));
    }

    public void ajustarValorEntrada(Boolean digitouValorEntrada, ParamParcelamento parametroParcelamento, BigDecimal valorEntradaCalculado) {
        if (digitouValorEntrada.booleanValue()) {
            if (this.getValorEntrada().compareTo(valorEntradaCalculado) < 0) {
                this.setValorEntrada(valorEntradaCalculado);
            }
        } else if (parametroParcelamento.getEntradaValorIgual().booleanValue()) {
            this.setValorEntrada(valorEntradaCalculado);
        } else {
            this.setValorEntrada(this.getValorEntrada().max(parametroParcelamento.getValorMinimoParcela()));
        }
    }

    public Integer getEntidade() {
        return this.entidade;
    }

    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    public LocalDate getDataCorrecao() {
        return this.dataCorrecao;
    }

    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    public Long getEntrada() {
        return this.entrada;
    }

    public Long getRequerente() {
        return this.requerente;
    }

    public BigDecimal getValorEntrada() {
        return this.valorEntrada;
    }

    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    public Integer getAnoProcessoPrazo() {
        return this.anoProcessoPrazo;
    }

    public Long getNumeroProcessoPrazo() {
        return this.numeroProcessoPrazo;
    }

    public LocalDate getDataProcessoPrazo() {
        return this.dataProcessoPrazo;
    }

    public LocalDate getDataProcessoOrigem() {
        return this.dataProcessoOrigem;
    }

    public BigDecimal getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public Boolean getDigitouDesconto() {
        return this.digitouDesconto;
    }

    public Integer getAnoProcessoDesconto() {
        return this.anoProcessoDesconto;
    }

    public Long getProcessoDesconto() {
        return this.processoDesconto;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public String getObservacaoUsuario() {
        return this.observacaoUsuario;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public List<Long> getDebitos() {
        return this.debitos;
    }

    public BigDecimal getTotalSelecionado() {
        return this.totalSelecionado;
    }

    public BigDecimal getValorDemaisParcelas() {
        return this.valorDemaisParcelas;
    }

    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    public BigDecimal getValorDescontos() {
        return this.valorDescontos;
    }

    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    public List<ParcelaParcelamentoDTO> getParcelas() {
        return this.parcelas;
    }

    public String getHash() {
        return this.hash;
    }

    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = anoContrato;
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    public void setDataCorrecao(LocalDate dataCorrecao) {
        this.dataCorrecao = dataCorrecao;
    }

    public void setNumeroParcelas(Integer numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    public void setEntrada(Long entrada) {
        this.entrada = entrada;
    }

    public void setRequerente(Long requerente) {
        this.requerente = requerente;
    }

    public void setValorEntrada(BigDecimal valorEntrada) {
        this.valorEntrada = valorEntrada;
    }

    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    public void setAnoProcessoPrazo(Integer anoProcessoPrazo) {
        this.anoProcessoPrazo = anoProcessoPrazo;
    }

    public void setNumeroProcessoPrazo(Long numeroProcessoPrazo) {
        this.numeroProcessoPrazo = numeroProcessoPrazo;
    }

    public void setDataProcessoPrazo(LocalDate dataProcessoPrazo) {
        this.dataProcessoPrazo = dataProcessoPrazo;
    }

    public void setDataProcessoOrigem(LocalDate dataProcessoOrigem) {
        this.dataProcessoOrigem = dataProcessoOrigem;
    }

    public void setPercentualDesconto(BigDecimal percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    public void setDigitouDesconto(Boolean digitouDesconto) {
        this.digitouDesconto = digitouDesconto;
    }

    public void setAnoProcessoDesconto(Integer anoProcessoDesconto) {
        this.anoProcessoDesconto = anoProcessoDesconto;
    }

    public void setProcessoDesconto(Long processoDesconto) {
        this.processoDesconto = processoDesconto;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setObservacaoUsuario(String observacaoUsuario) {
        this.observacaoUsuario = observacaoUsuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setDebitos(List<Long> debitos) {
        this.debitos = debitos;
    }

    public void setTotalSelecionado(BigDecimal totalSelecionado) {
        this.totalSelecionado = totalSelecionado;
    }

    public void setValorDemaisParcelas(BigDecimal valorDemaisParcelas) {
        this.valorDemaisParcelas = valorDemaisParcelas;
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setValorDescontos(BigDecimal valorDescontos) {
        this.valorDescontos = valorDescontos;
    }

    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    public void setParcelas(List<ParcelaParcelamentoDTO> parcelas) {
        this.parcelas = parcelas;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        return "SimulacaoParcelamentoDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipo=" + this.getTipo() + ", anoContrato=" + this.getAnoContrato() + ", idParametroParcelamento=" + this.getIdParametroParcelamento() + ", dataParcelamento=" + this.getDataParcelamento() + ", dataCorrecao=" + this.getDataCorrecao() + ", entrada=" + this.getEntrada() + ", valorEntrada=" + this.getValorEntrada() + ", dataEntrada=" + this.getDataEntrada() + ", debitos=" + this.getDebitos() + ", totalSelecionado=" + this.getTotalSelecionado() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimulacaoParcelamentoDTO)) {
            return false;
        }
        SimulacaoParcelamentoDTO other = (SimulacaoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$tipoCadastro = this.getTipoCadastro();
        Integer other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        TipoParcelamento this$tipo = this.getTipo();
        TipoParcelamento other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Long this$idParametroParcelamento = this.getIdParametroParcelamento();
        Long other$idParametroParcelamento = other.getIdParametroParcelamento();
        if (this$idParametroParcelamento == null ? other$idParametroParcelamento != null : !((Object)this$idParametroParcelamento).equals(other$idParametroParcelamento)) {
            return false;
        }
        LocalDate this$dataParcelamento = this.getDataParcelamento();
        LocalDate other$dataParcelamento = other.getDataParcelamento();
        if (this$dataParcelamento == null ? other$dataParcelamento != null : !((Object)this$dataParcelamento).equals(other$dataParcelamento)) {
            return false;
        }
        LocalDate this$dataCorrecao = this.getDataCorrecao();
        LocalDate other$dataCorrecao = other.getDataCorrecao();
        if (this$dataCorrecao == null ? other$dataCorrecao != null : !((Object)this$dataCorrecao).equals(other$dataCorrecao)) {
            return false;
        }
        Long this$entrada = this.getEntrada();
        Long other$entrada = other.getEntrada();
        if (this$entrada == null ? other$entrada != null : !((Object)this$entrada).equals(other$entrada)) {
            return false;
        }
        BigDecimal this$valorEntrada = this.getValorEntrada();
        BigDecimal other$valorEntrada = other.getValorEntrada();
        if (this$valorEntrada == null ? other$valorEntrada != null : !((Object)this$valorEntrada).equals(other$valorEntrada)) {
            return false;
        }
        LocalDate this$dataEntrada = this.getDataEntrada();
        LocalDate other$dataEntrada = other.getDataEntrada();
        if (this$dataEntrada == null ? other$dataEntrada != null : !((Object)this$dataEntrada).equals(other$dataEntrada)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        BigDecimal this$totalSelecionado = this.getTotalSelecionado();
        BigDecimal other$totalSelecionado = other.getTotalSelecionado();
        return !(this$totalSelecionado == null ? other$totalSelecionado != null : !((Object)this$totalSelecionado).equals(other$totalSelecionado));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimulacaoParcelamentoDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        TipoParcelamento $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Long $idParametroParcelamento = this.getIdParametroParcelamento();
        result = result * 59 + ($idParametroParcelamento == null ? 43 : ((Object)$idParametroParcelamento).hashCode());
        LocalDate $dataParcelamento = this.getDataParcelamento();
        result = result * 59 + ($dataParcelamento == null ? 43 : ((Object)$dataParcelamento).hashCode());
        LocalDate $dataCorrecao = this.getDataCorrecao();
        result = result * 59 + ($dataCorrecao == null ? 43 : ((Object)$dataCorrecao).hashCode());
        Long $entrada = this.getEntrada();
        result = result * 59 + ($entrada == null ? 43 : ((Object)$entrada).hashCode());
        BigDecimal $valorEntrada = this.getValorEntrada();
        result = result * 59 + ($valorEntrada == null ? 43 : ((Object)$valorEntrada).hashCode());
        LocalDate $dataEntrada = this.getDataEntrada();
        result = result * 59 + ($dataEntrada == null ? 43 : ((Object)$dataEntrada).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        BigDecimal $totalSelecionado = this.getTotalSelecionado();
        result = result * 59 + ($totalSelecionado == null ? 43 : ((Object)$totalSelecionado).hashCode());
        return result;
    }
}

