/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelaReceitaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.TributoParcelamentoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ParcelamentoHandler {
    private ParcelamentoHandler() {
    }

    public static List<ParcelaParcelamentoDTO> agruparPorParcela(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<ParcelaParcelamentoDTO> list = new ArrayList<ParcelaParcelamentoDTO>();
        Map<Long, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaReceita = debitos.stream().map(AiseDebitoParcelamentoDTO::getParcelaReceita).flatMap(Collection::stream).collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getParcela));
        listParcelaReceita.forEach((parcela, lista) -> {
            ParcelaParcelamentoDTO parcelaParcelamentoDTO = new ParcelaParcelamentoDTO();
            Optional parcelaReceita = lista.stream().findFirst();
            parcelaParcelamentoDTO.setParcela(parcela);
            parcelaParcelamentoDTO.setDataVencimento((LocalDate)parcelaReceita.map(AiseParcelaReceitaParcelamentoDTO::getDataVencimento).orElse(null));
            parcelaParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
            parcelaParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
            parcelaParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
            parcelaParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
            list.add(parcelaParcelamentoDTO);
        });
        return list;
    }

    public static List<ParcelaParcelamentoDTO> agruparPorDebitoParcela(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<ParcelaParcelamentoDTO> list = new ArrayList<ParcelaParcelamentoDTO>();
        debitos.stream().forEach(d -> {
            Map<Long, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaReceita = d.getParcelaReceita().stream().collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getParcela));
            listParcelaReceita.forEach((parcela, lista) -> {
                ParcelaParcelamentoDTO parcelaParcelamentoDTO = new ParcelaParcelamentoDTO();
                Optional parcelaReceita = lista.stream().findFirst();
                parcelaParcelamentoDTO.setExercicio(d.getExercicio());
                parcelaParcelamentoDTO.setDivida(d.getGuiaRecolhimento());
                parcelaParcelamentoDTO.setSubDivida(d.getSubDivida());
                parcelaParcelamentoDTO.setParcela(parcela);
                parcelaParcelamentoDTO.setDataVencimento((LocalDate)parcelaReceita.map(AiseParcelaReceitaParcelamentoDTO::getDataVencimento).orElse(null));
                parcelaParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
                parcelaParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
                parcelaParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
                parcelaParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2)));
                list.add(parcelaParcelamentoDTO);
            });
        });
        return list;
    }

    public static List<TributoParcelamentoDTO> agruparPorDebitoTributo(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<TributoParcelamentoDTO> list = new ArrayList<TributoParcelamentoDTO>();
        debitos.stream().forEach(d -> {
            Map<String, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaTributo = d.getParcelaReceita().stream().collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getReceita));
            listParcelaTributo.forEach((tributo, lista) -> {
                TributoParcelamentoDTO tributoParcelamentoDTO = new TributoParcelamentoDTO();
                tributoParcelamentoDTO.setExercicio(d.getExercicio());
                tributoParcelamentoDTO.setDivida(d.getGuiaRecolhimento());
                tributoParcelamentoDTO.setSubDivida(d.getSubDivida());
                tributoParcelamentoDTO.setTributo(tributo);
                tributoParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, (tributo1, tributo2) -> tributo1.add((BigDecimal)tributo2)));
                tributoParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, (tributo1, tributo2) -> tributo1.add((BigDecimal)tributo2)));
                tributoParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, (tributo1, tributo2) -> tributo1.add((BigDecimal)tributo2)));
                tributoParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, (tributo1, tributo2) -> tributo1.add((BigDecimal)tributo2)));
                list.add(tributoParcelamentoDTO);
            });
        });
        return list;
    }
}

