/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Pessoa;

public class PessoaDTO {
    private Long pessoa;
    private TipoPessoa tipoPessoa;
    private String cnpjCpf;
    private String nome;
    private String nomeFantasia;
    private String activeFormOrigem;
    private String tipoLogradouro;
    private String logradouro;
    private String bairro;
    private String numero;
    private String complemento;
    private String cidade;
    private String uf;
    private String cep;
    private String email;
    private String celular;
    private Long codigoCidadeAise;
    private Long codigoBairroAise;
    private Long codigoLogradouroAise;
    private Long codigoTipoLogradouroAise;

    public static PessoaDTO from(Pessoa pessoa) {
        PessoaDTO dto = new PessoaDTO();
        dto.setPessoa(pessoa.getId());
        dto.setTipoPessoa(pessoa.getTipoPessoa());
        dto.setCnpjCpf(pessoa.getCnpjCpf());
        dto.setNome(pessoa.getNome());
        dto.setNomeFantasia(pessoa.getNomeFantasia());
        dto.setActiveFormOrigem(pessoa.getActiveFormOrigem());
        dto.setTipoLogradouro(pessoa.getEnderecoPrincipal().getLogradouro().getTipoLogradouroDescricao());
        dto.setLogradouro(pessoa.getEnderecoPrincipal().getLogradouro().getDescricao());
        dto.setBairro(pessoa.getEnderecoPrincipal().getBairro().getDescricao());
        dto.setNumero(pessoa.getEnderecoPrincipal().getNumero());
        dto.setComplemento(pessoa.getEnderecoPrincipal().getComplemento());
        dto.setCidade(pessoa.getEnderecoPrincipal().getCidade().getDescricao());
        dto.setUf(pessoa.getEnderecoPrincipal().getUnidadeFederacao().getDescricao());
        dto.setCep(pessoa.getEnderecoPrincipal().getCep().toString());
        dto.setEmail(null);
        dto.setCelular(null);
        return dto;
    }

    public Long getPessoa() {
        return this.pessoa;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public String getActiveFormOrigem() {
        return this.activeFormOrigem;
    }

    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getCidade() {
        return this.cidade;
    }

    public String getUf() {
        return this.uf;
    }

    public String getCep() {
        return this.cep;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCelular() {
        return this.celular;
    }

    public Long getCodigoCidadeAise() {
        return this.codigoCidadeAise;
    }

    public Long getCodigoBairroAise() {
        return this.codigoBairroAise;
    }

    public Long getCodigoLogradouroAise() {
        return this.codigoLogradouroAise;
    }

    public Long getCodigoTipoLogradouroAise() {
        return this.codigoTipoLogradouroAise;
    }

    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public void setActiveFormOrigem(String activeFormOrigem) {
        this.activeFormOrigem = activeFormOrigem;
    }

    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public void setCodigoCidadeAise(Long codigoCidadeAise) {
        this.codigoCidadeAise = codigoCidadeAise;
    }

    public void setCodigoBairroAise(Long codigoBairroAise) {
        this.codigoBairroAise = codigoBairroAise;
    }

    public void setCodigoLogradouroAise(Long codigoLogradouroAise) {
        this.codigoLogradouroAise = codigoLogradouroAise;
    }

    public void setCodigoTipoLogradouroAise(Long codigoTipoLogradouroAise) {
        this.codigoTipoLogradouroAise = codigoTipoLogradouroAise;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PessoaDTO)) {
            return false;
        }
        PessoaDTO other = (PessoaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        TipoPessoa this$tipoPessoa = this.getTipoPessoa();
        TipoPessoa other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$nomeFantasia = this.getNomeFantasia();
        String other$nomeFantasia = other.getNomeFantasia();
        if (this$nomeFantasia == null ? other$nomeFantasia != null : !this$nomeFantasia.equals(other$nomeFantasia)) {
            return false;
        }
        String this$activeFormOrigem = this.getActiveFormOrigem();
        String other$activeFormOrigem = other.getActiveFormOrigem();
        if (this$activeFormOrigem == null ? other$activeFormOrigem != null : !this$activeFormOrigem.equals(other$activeFormOrigem)) {
            return false;
        }
        String this$tipoLogradouro = this.getTipoLogradouro();
        String other$tipoLogradouro = other.getTipoLogradouro();
        if (this$tipoLogradouro == null ? other$tipoLogradouro != null : !this$tipoLogradouro.equals(other$tipoLogradouro)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$celular = this.getCelular();
        String other$celular = other.getCelular();
        if (this$celular == null ? other$celular != null : !this$celular.equals(other$celular)) {
            return false;
        }
        Long this$codigoCidadeAise = this.getCodigoCidadeAise();
        Long other$codigoCidadeAise = other.getCodigoCidadeAise();
        if (this$codigoCidadeAise == null ? other$codigoCidadeAise != null : !((Object)this$codigoCidadeAise).equals(other$codigoCidadeAise)) {
            return false;
        }
        Long this$codigoBairroAise = this.getCodigoBairroAise();
        Long other$codigoBairroAise = other.getCodigoBairroAise();
        if (this$codigoBairroAise == null ? other$codigoBairroAise != null : !((Object)this$codigoBairroAise).equals(other$codigoBairroAise)) {
            return false;
        }
        Long this$codigoLogradouroAise = this.getCodigoLogradouroAise();
        Long other$codigoLogradouroAise = other.getCodigoLogradouroAise();
        if (this$codigoLogradouroAise == null ? other$codigoLogradouroAise != null : !((Object)this$codigoLogradouroAise).equals(other$codigoLogradouroAise)) {
            return false;
        }
        Long this$codigoTipoLogradouroAise = this.getCodigoTipoLogradouroAise();
        Long other$codigoTipoLogradouroAise = other.getCodigoTipoLogradouroAise();
        return !(this$codigoTipoLogradouroAise == null ? other$codigoTipoLogradouroAise != null : !((Object)this$codigoTipoLogradouroAise).equals(other$codigoTipoLogradouroAise));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PessoaDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        TipoPessoa $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $nomeFantasia = this.getNomeFantasia();
        result = result * 59 + ($nomeFantasia == null ? 43 : $nomeFantasia.hashCode());
        String $activeFormOrigem = this.getActiveFormOrigem();
        result = result * 59 + ($activeFormOrigem == null ? 43 : $activeFormOrigem.hashCode());
        String $tipoLogradouro = this.getTipoLogradouro();
        result = result * 59 + ($tipoLogradouro == null ? 43 : $tipoLogradouro.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $celular = this.getCelular();
        result = result * 59 + ($celular == null ? 43 : $celular.hashCode());
        Long $codigoCidadeAise = this.getCodigoCidadeAise();
        result = result * 59 + ($codigoCidadeAise == null ? 43 : ((Object)$codigoCidadeAise).hashCode());
        Long $codigoBairroAise = this.getCodigoBairroAise();
        result = result * 59 + ($codigoBairroAise == null ? 43 : ((Object)$codigoBairroAise).hashCode());
        Long $codigoLogradouroAise = this.getCodigoLogradouroAise();
        result = result * 59 + ($codigoLogradouroAise == null ? 43 : ((Object)$codigoLogradouroAise).hashCode());
        Long $codigoTipoLogradouroAise = this.getCodigoTipoLogradouroAise();
        result = result * 59 + ($codigoTipoLogradouroAise == null ? 43 : ((Object)$codigoTipoLogradouroAise).hashCode());
        return result;
    }

    public String toString() {
        return "PessoaDTO(pessoa=" + this.getPessoa() + ", tipoPessoa=" + this.getTipoPessoa() + ", cnpjCpf=" + this.getCnpjCpf() + ", nome=" + this.getNome() + ", nomeFantasia=" + this.getNomeFantasia() + ", activeFormOrigem=" + this.getActiveFormOrigem() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cidade=" + this.getCidade() + ", uf=" + this.getUf() + ", cep=" + this.getCep() + ", email=" + this.getEmail() + ", celular=" + this.getCelular() + ", codigoCidadeAise=" + this.getCodigoCidadeAise() + ", codigoBairroAise=" + this.getCodigoBairroAise() + ", codigoLogradouroAise=" + this.getCodigoLogradouroAise() + ", codigoTipoLogradouroAise=" + this.getCodigoTipoLogradouroAise() + ")";
    }
}

