/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;

public class DocumentoDTO {
    private Long id;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private BigDecimal valorVenalInformado;
    private String nomeRequerente;
    private String cpfRequerente;
    private Integer exercicio;
    private Integer tipoDocumento;
    private String descricaoTipoDocumento;
    private Long documento;
    private String url;
    private String codigoValidacao;
    private String usuario;
    private String cpfCnpj;
    private LocalDate dataEmissao;
    private LocalDate dataValidade;
    private String finalidade;
    private String subTipo;

    public static DocumentoDTO from(Documento documento) {
        DocumentoDTO documentoDTO = new DocumentoDTO();
        documentoDTO.setId(documento.getId());
        documentoDTO.setExercicio(documento.getExercicio());
        documentoDTO.setDocumento(documento.getDocumento());
        documentoDTO.setNomeRequerente(documento.getRequerente());
        documentoDTO.setCpfRequerente(documento.getCpfRequerente());
        documentoDTO.setCodigoValidacao(documento.getCodigoValidacao());
        documentoDTO.setCpfCnpj(documento.getCnpjCpf());
        documentoDTO.setDataEmissao(documento.getDataEmissao());
        documentoDTO.setDataValidade(documento.getDataValidade());
        documentoDTO.setSubTipo(documento.getSubTipo());
        Optional.ofNullable(documento.getSequenciaFinalidade()).ifPresent(finalidade -> documentoDTO.setFinalidade(finalidade.getDescricao()));
        Optional.ofNullable(documento.getTipoDocumento()).ifPresent(tipo -> documentoDTO.setTipoDocumento(Integer.valueOf(tipo.getId().intValue())));
        Optional.ofNullable(documento.getTipoDocumento()).ifPresent(tipo -> documentoDTO.setDescricaoTipoDocumento(tipo.getDescricao()));
        Optional.ofNullable(documento.getCadastroGeral()).map(CadastroGeral::getTipoCadastro).ifPresent(tipoCadastro -> documentoDTO.setTipoCadastro(TipoCadastro.fromValue((Long)tipoCadastro.getValue())));
        Optional.ofNullable(documento.getCadastroGeral()).ifPresent(cadastro -> documentoDTO.setCadastroGeral(cadastro.getCadastroGeral()));
        return documentoDTO;
    }

    public static DocumentoDTO from(Documento documento, String urlImpressao) {
        DocumentoDTO dto = new DocumentoDTO();
        dto.id = documento.getId();
        Optional.ofNullable(documento.getCadastroGeral()).ifPresent(cadastroGeral -> dto.setCadastroGeral(cadastroGeral.getCadastroGeral()));
        dto.exercicio = documento.getExercicio();
        Optional.ofNullable(documento.getTipoDocumento()).ifPresent(tipoDocumento -> dto.setTipoDocumento(Integer.valueOf(tipoDocumento.getId().intValue())));
        dto.documento = documento.getDocumento();
        dto.codigoValidacao = documento.getCodigoValidacao();
        dto.url = urlImpressao;
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public BigDecimal getValorVenalInformado() {
        return this.valorVenalInformado;
    }

    public void setValorVenalInformado(BigDecimal valorVenalInformado) {
        this.valorVenalInformado = valorVenalInformado;
    }

    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public Integer getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(Integer tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public String getDescricaoTipoDocumento() {
        return this.descricaoTipoDocumento;
    }

    public void setDescricaoTipoDocumento(String descricaoTipoDocumento) {
        this.descricaoTipoDocumento = descricaoTipoDocumento;
    }

    public Long getDocumento() {
        return this.documento;
    }

    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    public String getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(String finalidade) {
        this.finalidade = finalidade;
    }

    public String getSubTipo() {
        return this.subTipo;
    }

    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }
}

