/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmentoDemolicao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="TRIBIMOBILIARIOSEGMENTO")
@Audited
public class CadastroImobiliarioSegmento
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOSEGMENTO_ID")
    private Long id;
    @NotNull
    private Long sequencia;
    @ManyToOne
    @NotAudited
    private TipoSegmento tipoSegmento;
    @Min(value=1L)
    private @Min(value=1L) BigDecimal areaConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @NotAudited
    @ManyToOne
    @JoinColumn(name="idsituacaosegmento", referencedColumnName="idsituacaosegmento")
    private SituacaoSegmentoImob situacaoSegmento;
    private BigDecimal areaCoberta = BigDecimal.ZERO;
    private BigDecimal areaDescoberta = BigDecimal.ZERO;
    @EloSequence(sequenceName="S05IDSEGMENTOIMOBILIARIO")
    private Long idSegmentoImobiliario;
    @AuditJoinTable(name="TRIBBOLETIMIMOBSEG_IMOBSEG_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBIMOBILIARIOSEGMENTO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Boletim Segmento")
    private final List<BoletimImobiliarioSegmento> boletinsImobiliarioSegmento = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBIMOBILIARIOSEGMENTO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Segmento Demoli\u00e7\u00e3o")
    private final List<CadastroImobiliarioSegmentoDemolicao> cadastroImobiliarioSegmentoDml = new ArrayList();
    @NotNull
    @NotAudited
    private TipoCadastro tipoCadastro;
    @NotNull
    @NotAudited
    private Long cadastroGeral;

    public TipoSegmento getTipoSegmento() {
        return this.tipoSegmento;
    }

    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public SituacaoSegmentoImob getSituacaoSegmento() {
        return this.situacaoSegmento;
    }

    public BigDecimal getAreaCoberta() {
        return this.areaCoberta;
    }

    public BigDecimal getAreaDescoberta() {
        return this.areaDescoberta;
    }

    public Long getIdSegmentoImobiliario() {
        return this.idSegmentoImobiliario;
    }

    public void setTipoSegmento(TipoSegmento tipoSegmento) {
        this.tipoSegmento = tipoSegmento;
    }

    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public void setIdSituacaoSegmento(SituacaoSegmentoImob situacaoSegmento) {
        this.situacaoSegmento = situacaoSegmento;
    }

    public void setAreaCoberta(BigDecimal areaCoberta) {
        this.areaCoberta = areaCoberta;
    }

    public void setAreaDescoberta(BigDecimal areaDescoberta) {
        this.areaDescoberta = areaDescoberta;
    }

    public void setIdSegmentoImobiliario(Long idSegmentoImobiliario) {
        this.idSegmentoImobiliario = idSegmentoImobiliario;
    }

    public List<BoletimImobiliarioSegmento> getBoletinsImobiliarioSegmento() {
        return this.boletinsImobiliarioSegmento;
    }

    public List<CadastroImobiliarioSegmentoDemolicao> getCadastroImobiliarioSegmentoDml() {
        return this.cadastroImobiliarioSegmentoDml;
    }

    public Long getId() {
        return this.id;
    }

    public Long getSequencia() {
        return this.sequencia;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    public void setSituacaoSegmento(SituacaoSegmentoImob situacaoSegmento) {
        this.situacaoSegmento = situacaoSegmento;
    }

    public boolean isNew() {
        return this.id == null || this.getSequencia() == null;
    }

    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public String toString() {
        return "CadastroImobiliarioSegmento(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", tipoSegmento=" + this.getTipoSegmento() + ", areaConstruida=" + this.getAreaConstruida() + ", principal=" + this.getPrincipal() + ", situacaoSegmento=" + this.getSituacaoSegmento() + ", areaCoberta=" + this.getAreaCoberta() + ", areaDescoberta=" + this.getAreaDescoberta() + ", idSegmentoImobiliario=" + this.getIdSegmentoImobiliario() + ", boletinsImobiliarioSegmento=" + this.getBoletinsImobiliarioSegmento() + ", cadastroImobiliarioSegmentoDml=" + this.getCadastroImobiliarioSegmentoDml() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioSegmento)) {
            return false;
        }
        CadastroImobiliarioSegmento other = (CadastroImobiliarioSegmento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioSegmento;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

