/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.envers.Audited;

@Entity
@Table(name="TRIBIMOBILIARIOAVALIACAO")
@Audited
public class CadastroImobiliarioAvaliacao
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOAVALIACAO_ID")
    private Long id;
    @NotNull
    private Long sequencia;
    private LocalDate dataAvaliacao = LocalDate.now();
    @Min(value=0L)
    private @Min(value=0L) BigDecimal valorVenalTerritorial = BigDecimal.ZERO;
    @Min(value=0L)
    private @Min(value=0L) BigDecimal valorVenalPredial = BigDecimal.ZERO;
    @Min(value=0L)
    private @Min(value=0L) BigDecimal valorVenalTerritorialItbi = BigDecimal.ZERO;
    @Min(value=0L)
    private @Min(value=0L) BigDecimal valorVenalPredialItbi = BigDecimal.ZERO;
    @Caption(value="Informado Manual")
    @Column(length=15)
    private String usuario;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Informado Manual")
    private Boolean informadoManual = Boolean.TRUE;
    private Long entidade;
    private Long exercicio;
    private Long tipoCalculoDebito;
    private Long calculo;
    private BigDecimal valorVenalCondominio = BigDecimal.ZERO;
    private Long idCalculo;

    public LocalDate getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    public BigDecimal getValorVenalTerritorial() {
        return this.valorVenalTerritorial;
    }

    public BigDecimal getValorVenalPredial() {
        return this.valorVenalPredial;
    }

    public BigDecimal getValorVenalTerritorialItbi() {
        return this.valorVenalTerritorialItbi;
    }

    public BigDecimal getValorVenalPredialItbi() {
        return this.valorVenalPredialItbi;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public Boolean getInformadoManual() {
        return this.informadoManual;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public Long getTipoCalculoDebito() {
        return this.tipoCalculoDebito;
    }

    public Long getCalculo() {
        return this.calculo;
    }

    public BigDecimal getValorVenalCondominio() {
        return this.valorVenalCondominio;
    }

    public Long getIdCalculo() {
        return this.idCalculo;
    }

    public void setDataAvaliacao(LocalDate dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    public void setValorVenalTerritorial(BigDecimal valorVenalTerritorial) {
        this.valorVenalTerritorial = valorVenalTerritorial;
    }

    public void setValorVenalPredial(BigDecimal valorVenalPredial) {
        this.valorVenalPredial = valorVenalPredial;
    }

    public void setValorVenalTerritorialItbi(BigDecimal valorVenalTerritorialItbi) {
        this.valorVenalTerritorialItbi = valorVenalTerritorialItbi;
    }

    public void setValorVenalPredialItbi(BigDecimal valorVenalPredialItbi) {
        this.valorVenalPredialItbi = valorVenalPredialItbi;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setInformadoManual(Boolean informadoManual) {
        this.informadoManual = informadoManual;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setTipoCalculoDebito(Long tipoCalculoDebito) {
        this.tipoCalculoDebito = tipoCalculoDebito;
    }

    public void setCalculo(Long calculo) {
        this.calculo = calculo;
    }

    public void setValorVenalCondominio(BigDecimal valorVenalCondominio) {
        this.valorVenalCondominio = valorVenalCondominio;
    }

    public void setIdCalculo(Long idCalculo) {
        this.idCalculo = idCalculo;
    }

    public Long getId() {
        return this.id;
    }

    public Long getSequencia() {
        return this.sequencia;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    public boolean isNew() {
        return this.id == null || this.getSequencia() == null;
    }

    public String toString() {
        return "CadastroImobiliarioAvaliacao(dataAvaliacao=" + this.getDataAvaliacao() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioAvaliacao)) {
            return false;
        }
        CadastroImobiliarioAvaliacao other = (CadastroImobiliarioAvaliacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioAvaliacao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

