/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.acrescimo;

import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.domain.acrescimo.ValorIndiceId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="VALORINDICE")
public class ValorIndice {
    @EmbeddedId
    private ValorIndiceId id;
    @NotNull
    private BigDecimal valor;

    @JsonIgnore
    public IndiceCorrecao getIndiceCorrecao() {
        return Optional.ofNullable(this.id).map(ValorIndiceId::getIndiceCorrecao).orElse(null);
    }

    public void setIndiceCorrecao(IndiceCorrecao indiceCorrecao) {
        if (Objects.isNull(this.id)) {
            this.id = new ValorIndiceId();
        }
        this.id.setIndiceCorrecao(indiceCorrecao);
    }

    @JsonIgnore
    public LocalDate getData() {
        return Optional.ofNullable(this.id).map(ValorIndiceId::getData).orElse(null);
    }

    public void setData(LocalDate data) {
        if (Objects.isNull(this.id)) {
            this.id = new ValorIndiceId();
        }
        this.id.setData(data);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public ValorIndiceId getId() {
        return this.id;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setId(ValorIndiceId id) {
        this.id = id;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValorIndice)) {
            return false;
        }
        ValorIndice other = (ValorIndice)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ValorIndiceId this$id = this.getId();
        ValorIndiceId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValorIndice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValorIndiceId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "ValorIndice(id=" + this.getId() + ", valor=" + this.getValor() + ")";
    }
}

