/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.ClassificacaoTributo;
import br.com.elotech.tributos.domain.TipoInscrito;
import br.com.elotech.tributos.domain.TipoTributo;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribreceita")
public class Tributo
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="seq_receita")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotBlank
    @Length(max=5)
    @Column(name="receita")
    private @NotBlank @Length(max=5) String tributo;
    @NotNull
    @ManyToOne
    @JoinColumn(name="tiporeceita")
    private TipoTributo tipoTributo;
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String descricao;
    @Length(max=50)
    private @Length(max=50) String apelido;
    private ClassificacaoTributo classificacao;
    private Boolean incideJuros;
    private Boolean incideMulta;
    private Boolean incideCorrecao;
    private TipoInscrito inscrito;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativa;

    public Long getId() {
        return this.id;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public String getTributo() {
        return this.tributo;
    }

    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getApelido() {
        return this.apelido;
    }

    public ClassificacaoTributo getClassificacao() {
        return this.classificacao;
    }

    public Boolean getIncideJuros() {
        return this.incideJuros;
    }

    public Boolean getIncideMulta() {
        return this.incideMulta;
    }

    public Boolean getIncideCorrecao() {
        return this.incideCorrecao;
    }

    public TipoInscrito getInscrito() {
        return this.inscrito;
    }

    public Boolean getAtiva() {
        return this.ativa;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    public void setClassificacao(ClassificacaoTributo classificacao) {
        this.classificacao = classificacao;
    }

    public void setIncideJuros(Boolean incideJuros) {
        this.incideJuros = incideJuros;
    }

    public void setIncideMulta(Boolean incideMulta) {
        this.incideMulta = incideMulta;
    }

    public void setIncideCorrecao(Boolean incideCorrecao) {
        this.incideCorrecao = incideCorrecao;
    }

    public void setInscrito(TipoInscrito inscrito) {
        this.inscrito = inscrito;
    }

    public void setAtiva(Boolean ativa) {
        this.ativa = ativa;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tributo)) {
            return false;
        }
        Tributo other = (Tributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tributo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "Tributo(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tributo=" + this.getTributo() + ", tipoTributo=" + this.getTipoTributo() + ", descricao=" + this.getDescricao() + ", apelido=" + this.getApelido() + ", classificacao=" + this.getClassificacao() + ", incideJuros=" + this.getIncideJuros() + ", incideMulta=" + this.getIncideMulta() + ", incideCorrecao=" + this.getIncideCorrecao() + ", inscrito=" + this.getInscrito() + ", ativa=" + this.getAtiva() + ")";
    }
}

