/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.tributos.converter.TipoCadastroConverter;
import br.com.elotech.tributos.domain.ImobiliarioItbiObs;
import br.com.elotech.tributos.domain.ImobiliarioItbiObsId;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmento;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmentoId;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.ProprietarioItbiId;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoItbi;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.dto.ImobiliarioItbiDTO;
import br.com.elotech.tributos.dto.ImobiliarioItbiSegmentoDTO;
import br.com.elotech.tributos.exception.ProprietarioPrincipalItbiException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.http.HttpStatus;

@Entity
@Table(name="TRIBIMOBILIARIOITBI")
public class ImobiliarioItbi {
    @Id
    @EloSequence(sequenceName="s05imobiliarioitbi")
    @Column(name="idsequencia")
    @JsonProperty(value="idItbi")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @NotNull
    private TipoCadastro tipoCadastro;
    @NotNull
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private Long subDivida;
    private LocalDate dataLancamento;
    private LocalDate dataSituacao;
    @Length(max=15)
    private @Length(max=15) String usuario;
    private LocalDate dataInclusao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean transferido = Boolean.FALSE;
    private LocalDate dataVencimento;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorFinanciado = BigDecimal.ZERO;
    private BigDecimal aliquota = BigDecimal.ZERO;
    private BigDecimal aliquotaFinanciado = BigDecimal.ZERO;
    private BigDecimal baseCalculo = BigDecimal.ZERO;
    private BigDecimal baseCalculoFinanciado = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean todasUnidades = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean debitoGerado = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="tipoitbi")
    private TipoItbi tipoItbi;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean somenteTerreno = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean parcelado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean transfereAutomatico = Boolean.FALSE;
    @NotNull
    private Long codigoItbi;
    @ManyToOne
    @JoinColumn(name="parametroitbi")
    private ParametroItbi parametroItbi;
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiObs> observacoes = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProprietarioItbi> proprietarios = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiSegmento> segmentos = new ArrayList();

    public void addObservacao(ImobiliarioItbiObs obs) {
        ImobiliarioItbiObsId idObs = new ImobiliarioItbiObsId();
        idObs.setItbi(this);
        idObs.setSequencia(Long.valueOf(this.observacoes.size() + 1));
        obs.setId(idObs);
        this.observacoes.add(obs);
    }

    public void addProprietario(ProprietarioItbi proprietario, Pessoa pessoa, TipoProprietarioItbi tipoProprietarioItbi) {
        ProprietarioItbiId idProprietario = new ProprietarioItbiId();
        idProprietario.setItbi(this);
        idProprietario.setPessoa(pessoa);
        idProprietario.setTipoProprietarioItbi(tipoProprietarioItbi);
        proprietario.setId(idProprietario);
        this.proprietarios.add(proprietario);
    }

    public void addSegmento(ImobiliarioItbiSegmento segmento) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(Integer.valueOf(this.segmentos.size() + 1));
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public void addSegmento(ImobiliarioItbiSegmentoDTO segmentoDTO) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(segmentoDTO.getSequencia());
        ImobiliarioItbiSegmento segmento = new ImobiliarioItbiSegmento();
        segmento.setAreaConstruida(segmentoDTO.getAreaConstruida());
        segmento.setAreaItbi(segmentoDTO.getAreaItbi());
        segmento.setTipoSegmento(segmentoDTO.getTipoSegmento());
        segmento.setValorConstrucao(segmentoDTO.getValorConstrucao());
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public static ImobiliarioItbi from(ImobiliarioItbiDTO dto) {
        TipoCadastroConverter converter = new TipoCadastroConverter();
        ImobiliarioItbi itbi = new ImobiliarioItbi();
        itbi.setTipoCadastro(converter.convertToEntityAttribute(dto.getTipoCadastro()));
        itbi.setCadastroGeral(dto.getCadastroGeral());
        itbi.setTransfereAutomatico(dto.getTransfereAutomatico());
        itbi.setValor(dto.getValor());
        itbi.setValorFinanciado(dto.getValorFinanciado());
        itbi.setAliquota(dto.getAliquota());
        itbi.setAliquotaFinanciado(dto.getAliquotaFinanciado());
        itbi.setBaseCalculo(dto.getBaseCalculo());
        itbi.setBaseCalculoFinanciado(dto.getBaseCalculoFinanciado());
        itbi.setUsuario(dto.getUsuario());
        dto.getObservacoes().stream().map(ImobiliarioItbiObs::new).forEach(arg_0 -> itbi.addObservacao(arg_0));
        return itbi;
    }

    public void validar() {
        if (this.proprietarios.stream().filter(ProprietarioItbi::isAtual).noneMatch(ProprietarioItbi::getPrincipal)) {
            throw new ProprietarioPrincipalItbiException(HttpStatus.BAD_REQUEST, "Necess\u00e1rio informar um novo propriet\u00e1rio principal.");
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    public Long getSubDivida() {
        return this.subDivida;
    }

    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public Boolean getTransferido() {
        return this.transferido;
    }

    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public BigDecimal getValorFinanciado() {
        return this.valorFinanciado;
    }

    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    public BigDecimal getAliquotaFinanciado() {
        return this.aliquotaFinanciado;
    }

    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    public BigDecimal getBaseCalculoFinanciado() {
        return this.baseCalculoFinanciado;
    }

    public Boolean getTodasUnidades() {
        return this.todasUnidades;
    }

    public Boolean getDebitoGerado() {
        return this.debitoGerado;
    }

    public TipoItbi getTipoItbi() {
        return this.tipoItbi;
    }

    public Boolean getSomenteTerreno() {
        return this.somenteTerreno;
    }

    public Boolean getParcelado() {
        return this.parcelado;
    }

    public Boolean getTransfereAutomatico() {
        return this.transfereAutomatico;
    }

    public Long getCodigoItbi() {
        return this.codigoItbi;
    }

    public ParametroItbi getParametroItbi() {
        return this.parametroItbi;
    }

    public List<ImobiliarioItbiObs> getObservacoes() {
        return this.observacoes;
    }

    public List<ProprietarioItbi> getProprietarios() {
        return this.proprietarios;
    }

    public List<ImobiliarioItbiSegmento> getSegmentos() {
        return this.segmentos;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public void setTransferido(Boolean transferido) {
        this.transferido = transferido;
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public void setValorFinanciado(BigDecimal valorFinanciado) {
        this.valorFinanciado = valorFinanciado;
    }

    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    public void setAliquotaFinanciado(BigDecimal aliquotaFinanciado) {
        this.aliquotaFinanciado = aliquotaFinanciado;
    }

    public void setBaseCalculo(BigDecimal baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    public void setBaseCalculoFinanciado(BigDecimal baseCalculoFinanciado) {
        this.baseCalculoFinanciado = baseCalculoFinanciado;
    }

    public void setTodasUnidades(Boolean todasUnidades) {
        this.todasUnidades = todasUnidades;
    }

    public void setDebitoGerado(Boolean debitoGerado) {
        this.debitoGerado = debitoGerado;
    }

    public void setTipoItbi(TipoItbi tipoItbi) {
        this.tipoItbi = tipoItbi;
    }

    public void setSomenteTerreno(Boolean somenteTerreno) {
        this.somenteTerreno = somenteTerreno;
    }

    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    public void setTransfereAutomatico(Boolean transfereAutomatico) {
        this.transfereAutomatico = transfereAutomatico;
    }

    public void setCodigoItbi(Long codigoItbi) {
        this.codigoItbi = codigoItbi;
    }

    public void setParametroItbi(ParametroItbi parametroItbi) {
        this.parametroItbi = parametroItbi;
    }

    public void setObservacoes(List<ImobiliarioItbiObs> observacoes) {
        this.observacoes = observacoes;
    }

    public void setProprietarios(List<ProprietarioItbi> proprietarios) {
        this.proprietarios = proprietarios;
    }

    public void setSegmentos(List<ImobiliarioItbiSegmento> segmentos) {
        this.segmentos = segmentos;
    }

    public String toString() {
        return "ImobiliarioItbi(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + this.getDataLancamento() + ", dataSituacao=" + this.getDataSituacao() + ", usuario=" + this.getUsuario() + ", dataInclusao=" + this.getDataInclusao() + ", transferido=" + this.getTransferido() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", valorFinanciado=" + this.getValorFinanciado() + ", aliquota=" + this.getAliquota() + ", aliquotaFinanciado=" + this.getAliquotaFinanciado() + ", baseCalculo=" + this.getBaseCalculo() + ", baseCalculoFinanciado=" + this.getBaseCalculoFinanciado() + ", todasUnidades=" + this.getTodasUnidades() + ", debitoGerado=" + this.getDebitoGerado() + ", tipoItbi=" + this.getTipoItbi() + ", somenteTerreno=" + this.getSomenteTerreno() + ", parcelado=" + this.getParcelado() + ", transfereAutomatico=" + this.getTransfereAutomatico() + ", codigoItbi=" + this.getCodigoItbi() + ", parametroItbi=" + this.getParametroItbi() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioItbi)) {
            return false;
        }
        ImobiliarioItbi other = (ImobiliarioItbi)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioItbi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

