/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;

@Embeddable
public class EntidadeCorrecaoMultaEspecialId
implements Serializable {
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="sequencia", referencedColumnName="sequencia", updatable=false)})
    private EntidadeCorrecao entidadeCorrecao;
    @NotNull(message="Obrigat\u00f3rio uma Data Inicial para a Multa Especial")
    private @NotNull(message="Obrigat\u00f3rio uma Data Inicial para a Multa Especial") LocalDate dataInicial;
    @NotNull(message="Obrigat\u00f3rio uma Data Final para a Multa Especial")
    private @NotNull(message="Obrigat\u00f3rio uma Data Final para a Multa Especial") LocalDate dataFinal;

    public String toString() {
        String dadosEntidade = Objects.isNull(this.entidadeCorrecao) || Objects.isNull(this.entidadeCorrecao.getId()) ? "" : String.format("[entidade = %d, exercicio = %d, sequencia = %d]", this.entidadeCorrecao.getId().getEntidade(), this.entidadeCorrecao.getId().getExercicio(), this.entidadeCorrecao.getId().getSequencia());
        return "EntidadeCorrecaoMultaEspecialId [entidadeCorrecao=" + dadosEntidade + ", dataInicial=" + this.dataInicial + ", dataFinal=" + this.dataFinal + "]";
    }

    public EntidadeCorrecao getEntidadeCorrecao() {
        return this.entidadeCorrecao;
    }

    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    public void setEntidadeCorrecao(EntidadeCorrecao entidadeCorrecao) {
        this.entidadeCorrecao = entidadeCorrecao;
    }

    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }
}

