/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.EnderecoTipoStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="ENDERECOPESSOA")
public class EnderecoPessoa
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_ENDERECOPESSOA_ID")
    private Long id;
    @Column(name="sequencia")
    @NotNull
    private Long codigo;
    @Convert(converter=EnderecoTipoStringConverter.class)
    private EnderecoTipo tipoEndereco;
    @Length(max=1)
    private @Length(max=1) String domicilioFiscalEstabelecido;
    @Length(max=10)
    private @Length(max=10) String numero;
    @Length(max=100)
    private @Length(max=100) String complemento;
    @ManyToOne
    @JoinColumn
    private Cidade cidade;
    @ManyToOne
    @JoinColumn(name="LOGRADOURO_IDKEY")
    private Logradouro logradouro;
    @ManyToOne
    @JoinColumn(name="BAIRRO_IDKEY")
    private Bairro bairro;
    private Long cep;
    @ManyToOne
    @JoinColumn(name="UNIDADEFEDERACAO_IDKEY")
    private UnidadeFederacao unidadeFederacao;
    private LocalDate dataAlteracao;

    public EnderecoTipo getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(EnderecoTipo tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    public String getDomicilioFiscalEstabelecido() {
        return this.domicilioFiscalEstabelecido;
    }

    public void setDomicilioFiscalEstabelecido(String domicilioFiscalEstabelecido) {
        this.domicilioFiscalEstabelecido = domicilioFiscalEstabelecido;
    }

    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public Cidade getCidade() {
        return this.cidade;
    }

    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    public Bairro getBairro() {
        return this.bairro;
    }

    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    public Long getCep() {
        return this.cep;
    }

    public void setCep(Long cep) {
        this.cep = cep;
    }

    public UnidadeFederacao getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public void setUnidadeFederacao(UnidadeFederacao unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return "EnderecoPessoa(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", tipoEndereco=" + this.getTipoEndereco() + ", domicilioFiscalEstabelecido=" + this.getDomicilioFiscalEstabelecido() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cidade=" + this.getCidade() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", cep=" + this.getCep() + ", unidadeFederacao=" + this.getUnidadeFederacao() + ", dataAlteracao=" + this.getDataAlteracao() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnderecoPessoa)) {
            return false;
        }
        EnderecoPessoa other = (EnderecoPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnderecoPessoa;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

