/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBDEBITO")
public class Debito
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @EloSequence(sequenceName="S05IDDEBITO")
    @Column(name="iddebito")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @NotNull
    @ManyToOne
    @MapsId(value="entidade,exercicio,divida")
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento")})
    private Divida divida;
    @NotNull
    private Long subDivida;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean reparcelado;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean parcelado;
    @ManyToOne
    private FormaCorrecao formaCorrecao;
    private LocalDate dataLancamento;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Length(max=1000)
    private @Length(max=1000) String observacaoRevisao;
    @Length(max=15)
    private @Length(max=15) String usuario;
    private LocalDate dataInclusao;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Long getSubDivida() {
        return this.subDivida;
    }

    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    public Boolean getParcelado() {
        return this.parcelado;
    }

    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getObservacaoRevisao() {
        return this.observacaoRevisao;
    }

    public void setObservacaoRevisao(String observacaoRevisao) {
        this.observacaoRevisao = observacaoRevisao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public Divida getDivida() {
        return this.divida;
    }

    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    public CadastroGeralResumidoDTO getCadastroGeralResumido() {
        return CadastroGeralResumidoDTO.from((CadastroGeral)this.cadastroGeral);
    }
}

