select ger.tipocadastro,
       ger.cadastrogeral,
       pes.pessoa,
       pes.nome,
       pes.cnpj_cpf as cpfCnpj,
       deb.iddebito,
       guia.descricao,
       par.parcela,
       par.datavencimento,
       (select sum(valor)
        from tribdebitoparcelareceita rec
        where rec.entidade       = par.entidade
        and rec.exercicio        = par.exercicio
        and rec.tipocadastro     = par.tipocadastro
        and rec.cadastrogeral    = par.cadastrogeral
        and rec.guiarecolhimento = par.guiarecolhimento
        and rec.subdivida        = par.subdivida
        and rec.parcela          = par.parcela) as valor
from pessoa pes
inner join tribproprietario prop on prop.pessoa = pes.pessoa
inner join tribcadastrogeral ger on ger.tipocadastro  = prop.tipocadastro
                                and ger.cadastrogeral = prop.cadastrogeral
inner join tribdebito deb on deb.tipocadastro = ger.tipocadastro
                          and deb.cadastrogeral = ger.cadastrogeral
inner join tribguiarecolhimento guia on guia.entidade = deb.entidade
                                    and guia.exercicio = deb.exercicio
                                    and guia.guiarecolhimento = deb.guiarecolhimento
inner join tribdebitoparcela par on par.entidade         = deb.entidade
                                and par.exercicio        = deb.exercicio
                                and par.tipocadastro     = deb.tipocadastro
                                and par.cadastrogeral    = deb.cadastrogeral
                                and par.guiarecolhimento = deb.guiarecolhimento
                                and par.subdivida        = deb.subdivida
inner join tribsituacaoparcela sit on sit.situacaoparcela = par.situacaodebito
inner join tribtiposituacaoparcela tip on tip.tiposituacaoparcela = sit.situacaoparcela
where pes.cnpj_cpf      = ?
and   deb.constituido   = 'S'
and   tip.tipo          = 'A'
