/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.util;

import br.com.elotech.tributos.exception.AiseWebServiceExceptionUtils;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public final class AiseWebServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AiseWebServiceHandler.class);
    private static final Long DOCUMENTO_NAO_GERADO = 0L;

    private AiseWebServiceHandler() {
    }

    public static void checkDocumento(Long documento, String retorno) {
        LOG.debug("Verificando se documento foi gerado, c\u00f3digo documento: {}, retorno {}", (Object)documento, (Object)retorno);
        if (documento.equals(DOCUMENTO_NAO_GERADO)) {
            throw AiseWebServiceExceptionUtils.notFound((String)retorno);
        }
    }

    public static void checkDataValidadeDocumento(LocalDate dataValidade) {
        LOG.debug("Verificando data de validade do documento, data recebida {}", (Object)dataValidade);
        if (dataValidade.isBefore(LocalDate.now())) {
            throw AiseWebServiceExceptionUtils.status((HttpStatus)HttpStatus.NOT_FOUND, (String)"O Documento n\u00e3o pode ser emitido, pois est\u00e1 com a data de validade expirada.");
        }
    }
}

