/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.mapper;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.ws.domain.GeraBloquetoEnvio;
import br.com.elotech.tributos.ws.domain.GeraCarneEnvio;
import br.com.elotech.tributos.ws.domain.LoginResposta;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportListDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportListDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AiseWSMapper {
    private final DebitoMapper debitoMapper;
    private final ObjectMapper objectMapper;

    public AiseWSMapper(DebitoMapper debitoMapper, ObjectMapper objectMapper) {
        this.debitoMapper = debitoMapper;
        this.objectMapper = objectMapper;
    }

    public GeraBloquetoEnvio toEnvio(LoginResposta loginResposta, List<DebitoDTO> debitosMarcados) {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transportList.setItems(debitosDelphiMarcados);
        GeraBloquetoEnvio wsParams = new GeraBloquetoEnvio();
        wsParams.setUserKey(loginResposta.getUserKey());
        wsParams.setListaDebitos(this.objectMapper.writeValueAsString((Object)transport));
        return wsParams;
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados) {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transportList.setItems(debitosDelphiMarcados);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public String toEnvioRest(List<DebitoDTO> debitosMarcados, LocalDate dataReferencia) {
        List debitosDelphiMarcados = debitosMarcados.stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDelphiDTO(arg_0)).collect(Collectors.toList());
        DebitoTransportDTO transport = new DebitoTransportDTO();
        DebitoTransportListDTO transportList = new DebitoTransportListDTO();
        transport.setList(transportList);
        transport.setDataReferencia(dataReferencia);
        transportList.setItems(debitosDelphiMarcados);
        return this.objectMapper.writeValueAsString((Object)transport);
    }

    public GeraCarneEnvio toEnvio(LoginResposta loginResposta, DebitoCarneDTO debitoCarneDTO) {
        DebitoCarneResponseDTO debitoCarneResponseDTO = this.debitoMapper.toDebitoCarneResponseDTO(debitoCarneDTO);
        DebitoCarneTransportDTO transport = new DebitoCarneTransportDTO();
        DebitoCarneTransportListDTO transportList = new DebitoCarneTransportListDTO();
        transportList.getItems().add(debitoCarneResponseDTO);
        transport.setList(transportList);
        GeraCarneEnvio wsParams = new GeraCarneEnvio();
        wsParams.setUserKey(loginResposta.getUserKey());
        wsParams.setListaDebitos(this.objectMapper.writeValueAsString((Object)transport));
        return wsParams;
    }

    public String toEnvioRest(DebitoCarneDTO debitoCarneDTO) {
        DebitoCarneResponseDTO debitoCarneResponseDTO = this.debitoMapper.toDebitoCarneResponseDTO(debitoCarneDTO);
        DebitoCarneTransportDTO transport = new DebitoCarneTransportDTO();
        DebitoCarneTransportListDTO transportList = new DebitoCarneTransportListDTO();
        transportList.getItems().add(debitoCarneResponseDTO);
        transport.setList(transportList);
        return this.objectMapper.writeValueAsString((Object)transport);
    }
}

