/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.repository.VinculoRepository;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class ProprietarioValidator
implements CustomValidator<CadastroImobiliario> {
    private static final int CEM_POR_CENTO = 100;
    private final PessoaRepository pessoaRepository;
    private final VinculoRepository vinculoRepository;

    public ProprietarioValidator(PessoaRepository pessoaRepository, VinculoRepository vinculoRepository) {
        this.pessoaRepository = pessoaRepository;
        this.vinculoRepository = vinculoRepository;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
        List proprietarios = cadastroImobiliario.getProprietarios();
        this.validaPercentual(errors, proprietarios);
        this.validaPessoaInativo(errors, proprietarios);
        this.validaCoResponsavelPrincipal(errors, proprietarios);
        this.validaProprietarioPrincipal(errors, proprietarios);
        this.validaTipoVinculoPrincipal(errors, proprietarios);
    }

    private void validaPercentual(Errors errors, List<Proprietario> proprietarios) {
        BigDecimal percentualTotal = proprietarios.stream().map(Proprietario::getPercentual).reduce(BigDecimal::add).get();
        if (!percentualTotal.equals(BigDecimal.valueOf(100L))) {
            errors.reject("Percentual diferente de 100%", "O percentual do(s) propriet\u00e1rio(s) deve estar em 100%.");
        }
    }

    private void validaPessoaInativo(Errors errors, List<Proprietario> proprietarios) {
        proprietarios.stream().filter(proprietario -> this.filtraPessoaInativo(proprietario.getPessoa().getId())).forEach(proprietario -> errors.reject("Pessoa Inativo", "Contribuinte " + proprietario.getPessoa().getId() + " utilizado como propriet\u00e1rio est\u00e1 inativo."));
    }

    private Boolean filtraPessoaInativo(Long idPessoa) {
        Pessoa pessoa = (Pessoa)this.pessoaRepository.findOne((Object)idPessoa);
        if (pessoa != null) {
            return pessoa.getInativo();
        }
        return false;
    }

    private void validaProprietarioPrincipal(Errors errors, List<Proprietario> proprietarios) {
        proprietarios.stream().filter(proprietario -> this.filterProprietarioPrincipal(proprietario)).forEach(proprietario -> errors.reject("Tipo Vinculo/Principal", "Propriet\u00e1rio \u00e9 o principal, tipo v\u00ednculo tamb\u00e9m deve ser, verificar propriet\u00e1rio " + proprietario.getPessoa().getId()));
    }

    private void validaTipoVinculoPrincipal(Errors errors, List<Proprietario> proprietarios) {
        proprietarios.stream().filter(proprietario -> this.filterTipoVinculoPrincipal(proprietario)).forEach(proprietario -> errors.reject("Tipo Vinculo/Principal", "Tipo v\u00ednculo \u00e9 do tipo Principal, propriet\u00e1rio " + proprietario.getPessoa().getId() + " tamb\u00e9m deve estar marcado como principal"));
    }

    private Boolean filterProprietarioPrincipal(Proprietario proprietario) {
        Vinculo vinculo = (Vinculo)this.vinculoRepository.findOne((Object)proprietario.getVinculo().getId());
        if (vinculo != null) {
            return proprietario.getPrincipal() != false && vinculo.getTipoVinculo().isPrincipal() == false;
        }
        return false;
    }

    private Boolean filterTipoVinculoPrincipal(Proprietario proprietario) {
        Vinculo vinculo = (Vinculo)this.vinculoRepository.findOne((Object)proprietario.getVinculo().getId());
        if (vinculo != null) {
            return vinculo.getTipoVinculo().isPrincipal() != false && proprietario.getPrincipal() == false;
        }
        return false;
    }

    private void validaCoResponsavelPrincipal(Errors errors, List<Proprietario> proprietarios) {
        proprietarios.stream().filter(proprietario -> this.filterProprietarioNotCoResponsavel(proprietario)).forEach(proprietario -> errors.reject("CoResponsavelPrincipal incorreto", "Valor CoResponsavelPrincipal do propriet\u00e1rio da pessoa " + proprietario.getPessoa().getId() + " deve ser falso."));
    }

    private Boolean filterProprietarioNotCoResponsavel(Proprietario proprietario) {
        Vinculo vinculo = (Vinculo)this.vinculoRepository.findOne((Object)proprietario.getVinculo().getId());
        if (vinculo != null) {
            return vinculo.getTipoVinculo().isCoResponsavel() == false && proprietario.getCoResponsavelPrincipal() != false;
        }
        return false;
    }
}

