/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.repository.LogradouroTestadaRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.validator.CadastroImobiliarioTestadaValidatorUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class CadastroImobiliarioTestadaValidator
implements CustomValidator<CadastroImobiliario> {
    private final ParametroGeralService parametroGeralService;
    private final LogradouroTestadaRepository logradouroTestadaRepository;

    public CadastroImobiliarioTestadaValidator(ParametroGeralService parametroGeralService, LogradouroTestadaRepository logradouroTestadaRepository) {
        this.parametroGeralService = parametroGeralService;
        this.logradouroTestadaRepository = logradouroTestadaRepository;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
        List testadas = cadastroImobiliario.getCadastroImobiliarioTestadas();
        this.validaCondominioCadastro(errors, cadastroImobiliario, testadas);
        this.validaTestadaCadastro(errors, cadastroImobiliario, testadas);
        if (this.parametroValidaBoletimLogradouro().booleanValue()) {
            this.validaTestadaDistritoSetorQuadra(cadastroImobiliario, testadas, errors);
        }
        if (CadastroImobiliarioTestadaValidatorUtils.validaPrincipalInvalido((List)testadas)) {
            errors.reject("Testada com Principal Inv\u00e1lido", "O Cadastro dever\u00e1 possuir obrigatoriamente uma testada");
        }
    }

    private void validaTestadaCadastro(Errors errors, CadastroImobiliario cadastroImobiliario, List<CadastroImobiliarioTestada> testadas) {
        if (this.parametroValidaTestadaCadastro().booleanValue()) {
            if (!CadastroImobiliarioTestadaValidatorUtils.existsTestadaPrincipal(testadas)) {
                errors.reject("Cadastro sem Testada Principal", "\u00c9 necess\u00e1rio informar a testada principal do im\u00f3vel");
            }
            if (!this.existsTestadaQuadrasIguais(cadastroImobiliario, testadas)) {
                errors.reject("Testada com Quadra Inv\u00e1lida", "A Quadra tem que ser igual a cadastrada na testada do im\u00f3vel");
            }
            if (!this.existsTestadaSetoresIguais(cadastroImobiliario, testadas)) {
                errors.reject("Testada com Setor Inv\u00e1lida", "O Setor tem que ser igual a cadastrada na testada do im\u00f3vel");
            }
        }
    }

    private void validaCondominioCadastro(Errors errors, CadastroImobiliario cadastroImobiliario, List<CadastroImobiliarioTestada> testadas) {
        if (this.parametroValidaCondominioCadastro().booleanValue()) {
            if (!CadastroImobiliarioTestadaValidatorUtils.existsTestadaUtilizaParaCalculoTrue(testadas)) {
                errors.reject("Usado para c\u00e1lculo est\u00e1 incorreto para Logradouro", "\u00c9 necess\u00e1rio pelo menos um Logradouro com  o campo 'USADO PARA CALCULO' igual a 'Sim'.");
            }
            if (CadastroImobiliarioTestadaValidatorUtils.existsTestadaUtilizaParaCalculoFalse(testadas) && CadastroImobiliarioTestadaValidatorUtils.notExistsCondominio((CadastroImobiliario)cadastroImobiliario)) {
                errors.reject("Usado para c\u00e1lculo est\u00e1 incorreto para condom\u00ednio", "Para cadastro sem condom\u00ednio n\u00e3o pode existir 'USADO PARA CALCULO' recebendo a informa\u00e7\u00e3o 'N\u00e3o'");
            }
            CadastroImobiliarioTestadaValidatorUtils.validaTestada(testadas, (Errors)errors);
        }
    }

    private boolean existsTestadaQuadrasIguais(CadastroImobiliario imobiliario, List<CadastroImobiliarioTestada> testadas) {
        return testadas.stream().filter(testada -> this.validaQuadraIguais(imobiliario.getQuadraInscricaoCadastral(), testada)).findFirst().isPresent();
    }

    private boolean validaQuadraIguais(String quadraImobiliario, CadastroImobiliarioTestada imobiliarioTestada) {
        LogradouroTestada logradouroTestada = (LogradouroTestada)this.logradouroTestadaRepository.findOne((Object)imobiliarioTestada.getLogradouroTestada().getId());
        return quadraImobiliario.equals(logradouroTestada.getQuadra());
    }

    private boolean existsTestadaSetoresIguais(CadastroImobiliario imobiliario, List<CadastroImobiliarioTestada> testadas) {
        if (Objects.nonNull(imobiliario.getSetorInscricaoCadastral())) {
            return testadas.stream().filter(testada -> this.validaSetoresIguais(imobiliario.getSetorInscricaoCadastral().getSetor(), testada)).findFirst().isPresent();
        }
        return false;
    }

    private boolean validaSetoresIguais(String setorImobiliario, CadastroImobiliarioTestada imobiliarioTestada) {
        LogradouroTestada logradouroTestada = (LogradouroTestada)this.logradouroTestadaRepository.findOne((Object)imobiliarioTestada.getLogradouroTestada().getId());
        return setorImobiliario.equals(logradouroTestada.getLogradouroTrecho().getSetor().getSetor());
    }

    private boolean validaDistritoSetorQuadraIguais(CadastroImobiliario cadastroImobiliario, CadastroImobiliarioTestada imobiliarioTestada) {
        LogradouroTestada logradouroTestada = (LogradouroTestada)this.logradouroTestadaRepository.findOne((Object)imobiliarioTestada.getLogradouroTestada().getId());
        if (Objects.nonNull(cadastroImobiliario.getDistritoInscricaoCadastral()) && Objects.nonNull(cadastroImobiliario.getSetorInscricaoCadastral())) {
            return cadastroImobiliario.getDistritoInscricaoCadastral().getDistrito().equals(logradouroTestada.getLogradouroTrecho().getSetor().getDistrito().getDistrito()) && cadastroImobiliario.getSetorInscricaoCadastral().getSetor().equals(logradouroTestada.getLogradouroTrecho().getSetor().getSetor()) && cadastroImobiliario.getQuadraInscricaoCadastral().equals(logradouroTestada.getQuadra());
        }
        return false;
    }

    private void validaTestadaDistritoSetorQuadra(CadastroImobiliario cadastroImobiliario, List<CadastroImobiliarioTestada> testadas, Errors errors) {
        testadas.stream().filter(testada -> !this.validaDistritoSetorQuadraIguais(cadastroImobiliario, testada)).forEach(testada -> CadastroImobiliarioTestadaValidatorUtils.errorValidaTestadaDistritoSetorQuadra((Errors)errors, (Long)testada.getLogradouroTestada().getId()));
    }

    private Boolean parametroValidaCondominioCadastro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_CONDOMINIO_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean parametroValidaTestadaCadastro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_TESTADA_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean parametroValidaBoletimLogradouro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_BOLETIM_LOGRADOURO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

